/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.resources;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.io.IOUtils;

class ResourceReader {
    public static String readStringFromResource(String resourceFileName, ClassLoader classLoader) throws IOException {
        InputStream helpDisplayResource = classLoader.getResourceAsStream(resourceFileName);
        if (helpDisplayResource != null) {
            return IOUtils.toString((InputStream)helpDisplayResource, (Charset)StandardCharsets.UTF_8);
        }
        return resourceFileName + " is missing, so cannot display.";
    }

    public static String keyFromMavenProperties(String key, String fallback, String resourceFileName, ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        InputStream mavenPropertiesResource = classLoader.getResourceAsStream(resourceFileName);
        if (mavenPropertiesResource == null) {
            return fallback;
        }
        try (InputStream resourceStream = mavenPropertiesResource;){
            properties.load(resourceStream);
        }
        if (properties.containsKey(key)) {
            return properties.getProperty(key);
        }
        throw new IOException("a property is missing from maven properties: " + key);
    }

    @Generated
    private ResourceReader() {
    }
}

