/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.resources;

import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.launcher.resources.ResourceReader;

public class Resources {
    private ClassLoader classLoader;
    private String pathVersionFooter;
    private String pathMavenProperties;
    private String pathUsageHeader;
    private String pathUsageFooter;
    private Optional<String> pathTasksFooter;

    public String usageHeader() {
        return this.readTextFile(this.pathUsageHeader);
    }

    public String usageFooter() {
        return this.readTextFile(this.pathUsageFooter);
    }

    public String tasksFooter() {
        return this.pathTasksFooter.map(this::readTextFile).orElse("");
    }

    public String versionFooter() {
        return this.readTextFile(this.pathVersionFooter);
    }

    public String versionFromMavenProperties() throws IOException {
        return ResourceReader.keyFromMavenProperties("version", "<unknown>", this.pathMavenProperties, this.classLoader);
    }

    private String readTextFile(String path) {
        try {
            return ResourceReader.readStringFromResource(path, this.classLoader);
        }
        catch (IOException e) {
            return "Error: Cannot read a string from the file: " + path;
        }
    }

    @Generated
    public Resources(ClassLoader classLoader, String pathVersionFooter, String pathMavenProperties, String pathUsageHeader, String pathUsageFooter, Optional<String> pathTasksFooter) {
        this.classLoader = classLoader;
        this.pathVersionFooter = pathVersionFooter;
        this.pathMavenProperties = pathMavenProperties;
        this.pathUsageHeader = pathUsageHeader;
        this.pathUsageFooter = pathUsageFooter;
        this.pathTasksFooter = pathTasksFooter;
    }
}

