/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.run;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.experiment.ExperimentExecutionException;

class ErrorPrinter {
    private static final int ERROR_LOG_WRAP_MESSAGE = 200;

    public static void printTooManyArguments() {
        System.err.println("Please only pass a single experiment-file as an argument. Multiple files are not allowed");
    }

    public static void printErrorLog(ExperimentExecutionException cause, Path errorLogPath) {
        try {
            FileWriter writer = new FileWriter(errorLogPath.toFile());
            cause.friendlyMessageHierarchy((Writer)writer, 200, true);
            writer.write(System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("STACK TRACE:");
            writer.write(System.lineSeparator());
            cause.printStackTrace(new PrintWriter(writer));
            writer.close();
        }
        catch (IOException exc) {
            System.err.printf("Cannot write the error log due to an I/O error%n", new Object[0]);
            System.err.println(exc.toString());
        }
    }

    @Generated
    private ErrorPrinter() {
    }
}

