/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.run;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.core.functional.checked.CheckedRunnable;
import org.anchoranalysis.launcher.config.HelpConfig;
import org.anchoranalysis.launcher.options.CommandLineExtracter;
import org.anchoranalysis.launcher.resources.Resources;
import org.anchoranalysis.launcher.run.tasks.PredefinedTasks;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

class MessagePrinter {
    private static final int CONSOLE_WIDTH = 160;
    private static final PrintStream PRINT_TO = System.out;
    private final Resources resources;

    public boolean maybePrintHelp(CommandLine line, Options options, HelpConfig helpConfig) {
        return MessagePrinter.runIfOption(line, "h", () -> this.printHelp(options, helpConfig.getCommandName(), helpConfig.getFirstArgument()));
    }

    public boolean maybePrintVersion(CommandLine line) throws IOException {
        return MessagePrinter.runIfOption(line, "v", this::printVersion);
    }

    public boolean maybeShowTasks(CommandLine line, Path tasksDirectory) {
        CommandLineExtracter extract = new CommandLineExtracter(line);
        if (extract.hasOptionWithoutArgument("t")) {
            PredefinedTasks.printTasksToConsole(tasksDirectory, this.resources, PRINT_TO);
            return true;
        }
        return MessagePrinter.runIfOption(line, "st", () -> PredefinedTasks.printTasksToConsole(tasksDirectory, this.resources, PRINT_TO));
    }

    private void printVersion() throws IOException {
        PRINT_TO.printf("anchor version %s by Owen Feehan (ETH Zurich, University of Zurich, 2016)%n", this.resources.versionFromMavenProperties());
        PRINT_TO.println();
        PRINT_TO.print(this.resources.versionFooter());
    }

    private void printHelp(Options options, String commandNameInHelp, String firstArgumentInHelp) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(160);
        String firstLine = String.format("%s [options] [%s]", commandNameInHelp, firstArgumentInHelp);
        formatter.printHelp(firstLine, this.resources.usageHeader(), options, this.resources.usageFooter());
    }

    private static <E extends Exception> boolean runIfOption(CommandLine line, String option, CheckedRunnable<E> runnable) throws E {
        if (line.hasOption(option)) {
            runnable.run();
            return true;
        }
        return false;
    }

    @Generated
    public MessagePrinter(Resources resources) {
        this.resources = resources;
    }
}

