/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.config;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.launcher.config.HelpConfig;
import org.anchoranalysis.launcher.config.PathCurrentJarHelper;
import org.anchoranalysis.launcher.config.PathDeriver;
import org.anchoranalysis.launcher.executor.ExperimentExecutor;
import org.anchoranalysis.launcher.executor.ExperimentExecutorFactory;
import org.anchoranalysis.launcher.resources.Resources;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public abstract class LauncherConfig {
    public abstract Resources resources();

    public abstract HelpConfig help();

    public abstract boolean newlinesBeforeError();

    public abstract ExecutionArguments createArguments(CommandLine var1) throws ExperimentExecutionException;

    public abstract void addAdditionalOptions(Options var1);

    public ExperimentExecutor createExperimentExecutor(CommandLine line, Optional<Path> defaultExperiment) throws ExperimentExecutionException {
        Path path = (Path)OptionalUtilities.orElseGet(defaultExperiment, this::inferPathDefaultExperimentFromProperties);
        return ExperimentExecutorFactory.create(line, path, path.getParent());
    }

    public abstract void customizeExperimentExecutor(ExperimentExecutor var1, CommandLine var2) throws ExperimentExecutionException;

    protected abstract String pathRelativeProperties();

    protected abstract Class<?> classInCurrentJar();

    private Path inferPathDefaultExperimentFromProperties() throws ExperimentExecutionException {
        Path pathCurrentJARDir = PathCurrentJarHelper.pathCurrentJAR(this.classInCurrentJar());
        return PathDeriver.pathDefaultExperiment(pathCurrentJARDir, this.pathRelativeProperties());
    }
}

