/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor;

import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.bean.xml.BeanXMLLoader;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.bean.Experiment;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.bean.InputManager;
import org.anchoranalysis.io.output.bean.OutputManager;

class BeanReader {
    public static Experiment readExperimentFromXML(Path configPath) throws ExperimentExecutionException {
        return (Experiment)BeanReader.readBeanFromXML(configPath, "experiment", true);
    }

    public static InputManager<InputFromManager> readInputManagerFromXML(Path configPath) throws ExperimentExecutionException {
        return (InputManager)BeanReader.readBeanFromXML(configPath, "bean", false);
    }

    public static OutputManager readOutputManagerFromXML(Path configPath) throws ExperimentExecutionException {
        return (OutputManager)BeanReader.readBeanFromXML(configPath, "bean", false);
    }

    public static Task<InputFromManager, Object> readTaskFromXML(Path configPath) throws ExperimentExecutionException {
        return (Task)BeanReader.readBeanFromXML(configPath, "bean", false);
    }

    private static <T> T readBeanFromXML(Path configPath, String xmlPath, boolean associateXml) throws ExperimentExecutionException {
        if (!(configPath = configPath.normalize()).toFile().exists()) {
            throw new ExperimentExecutionException(String.format("Error: a file does not exist at \"%s\"", configPath));
        }
        try {
            if (associateXml) {
                return (T)BeanXMLLoader.loadBeanAssociatedXml((Path)configPath, (String)xmlPath);
            }
            return (T)BeanXMLLoader.loadBean((Path)configPath, (String)xmlPath);
        }
        catch (BeanXMLException e) {
            String errorMsg = String.format("An error occurred reading the experiment bean XML at \"%s\".%nPlease ensure this is validly-formatted BeanXML for an experiment.", configPath);
            throw new ExperimentExecutionException(errorMsg, (Throwable)e);
        }
    }

    @Generated
    private BeanReader() {
    }
}

