/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.xml.RegisterBeanFactories;
import org.anchoranalysis.bean.xml.factory.AnchorDefaultBeanFactory;
import org.anchoranalysis.core.collection.StringSetTrie;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.experiment.bean.Experiment;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.io.ReplaceInputManager;
import org.anchoranalysis.experiment.io.ReplaceOutputManager;
import org.anchoranalysis.experiment.io.ReplaceTask;
import org.anchoranalysis.feature.bean.RegisterFeatureBeanFactories;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.bean.InputManager;
import org.anchoranalysis.io.output.bean.OutputManager;
import org.anchoranalysis.launcher.executor.BeanReader;
import org.anchoranalysis.launcher.executor.HelperLoadAdditionalConfig;

class ExperimentExecutorAfter {
    private static Optional<StringSetTrie> defaultExtensions = Optional.empty();

    public ExperimentExecutorAfter(Path pathConfigurationDirectory) throws ExperimentExecutionException {
        ExperimentExecutorAfter.initializeIfNecessary(pathConfigurationDirectory, true, true);
    }

    static void initializeIfNecessary(Path pathConfigurationDirectory, boolean includeDefaultInstances, boolean includeRootPaths) throws ExperimentExecutionException {
        if (!RegisterBeanFactories.isCalledRegisterAllPackage()) {
            AnchorDefaultBeanFactory defaultFactory = RegisterBeanFactories.registerAllPackageBeanFactories();
            RegisterFeatureBeanFactories.registerBeanFactories();
            if (includeDefaultInstances) {
                defaultFactory.getDefaultInstances().addFrom(HelperLoadAdditionalConfig.loadDefaultInstances(pathConfigurationDirectory));
            }
            if (includeRootPaths) {
                HelperLoadAdditionalConfig.loadRootPaths(pathConfigurationDirectory);
            }
            if (!defaultExtensions.isPresent()) {
                defaultExtensions = HelperLoadAdditionalConfig.loadDefaultExtensions(pathConfigurationDirectory);
            }
        }
    }

    public void executeExperiment(Experiment experiment, ExecutionArguments executionArguments, Optional<Path> pathInput, Optional<Path> pathOutput, Optional<Path> pathTask) throws ExperimentExecutionException {
        executionArguments.inputContextParameters().assignInputFilterExtensionsIfMissing(() -> defaultExtensions);
        OptionalUtilities.ifPresent(pathInput, path -> this.replaceInputManager(experiment, (Path)path));
        OptionalUtilities.ifPresent(pathOutput, path -> this.replaceOutputManager(experiment, (Path)path));
        OptionalUtilities.ifPresent(pathTask, path -> this.replaceTask(experiment, (Path)path));
        this.executeExperiment(experiment, executionArguments);
    }

    private void replaceInputManager(Experiment experiment, Path pathInput) throws ExperimentExecutionException {
        InputManager<InputFromManager> inputManager = BeanReader.readInputManagerFromXML(pathInput);
        try {
            if (!(experiment instanceof ReplaceInputManager)) {
                throw new ExperimentExecutionException(String.format("To override the input of an experiment, it must implement %s.%nThe current experiment does not: %s", ReplaceInputManager.class.getName(), experiment.getClass().getName()));
            }
            ReplaceInputManager experimentCasted = (ReplaceInputManager)experiment;
            experimentCasted.replaceInputManager(inputManager);
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException(String.format("Cannot override the input of an experiment %s with input-manager type %s", experiment.getClass().getName(), inputManager.getClass().getName()), (Throwable)e);
        }
    }

    private void replaceOutputManager(Experiment experiment, Path pathOutput) throws ExperimentExecutionException {
        OutputManager outputManager = BeanReader.readOutputManagerFromXML(pathOutput);
        try {
            if (!(experiment instanceof ReplaceOutputManager)) {
                throw new ExperimentExecutionException(String.format("To override the output of an experiment, it must implement %s.%nThe current experiment does not: %s", ReplaceOutputManager.class.getName(), experiment.getClass().getName()));
            }
            ReplaceOutputManager experimentCasted = (ReplaceOutputManager)experiment;
            experimentCasted.replaceOutputManager(outputManager);
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException(String.format("Cannot override the output of an experiment %s with input-manager type %s", experiment.getClass().getName(), outputManager.getClass().getName()), (Throwable)e);
        }
    }

    private void replaceTask(Experiment experiment, Path pathTask) throws ExperimentExecutionException {
        Task<InputFromManager, Object> task = BeanReader.readTaskFromXML(pathTask);
        try {
            if (!(experiment instanceof ReplaceTask)) {
                throw new ExperimentExecutionException(String.format("To override the task of an experiment, it must implement %s.%nThe current experiment does not: %s", ReplaceTask.class.getName(), experiment.getClass().getName()));
            }
            ReplaceTask experimentCasted = (ReplaceTask)experiment;
            experimentCasted.replaceTask(task);
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException(String.format("Cannot override the input of an experiment %s with task type %s", experiment.getClass().getName(), task.getClass().getName()), (Throwable)e);
        }
    }

    private void executeExperiment(Experiment experiment, ExecutionArguments executionArguments) throws ExperimentExecutionException {
        try {
            experiment.executeExperiment(executionArguments);
        }
        catch (ExperimentExecutionException e) {
            throw new ExperimentExecutionException("Experiment execution ended with failure", (Throwable)e);
        }
    }
}

