/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.primitive.StringSet;
import org.anchoranalysis.bean.xml.BeanXMLLoader;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.core.collection.StringSetTrie;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.plugin.io.input.path.RootPathMap;

class HelperLoadAdditionalConfig {
    private static final String ANCHOR_USER_SUBDIR = ".anchor/";
    private static final String DEFAULT_INSTANCES_FILENAME = "defaultBeans.xml";
    private static final String DEFAULT_EXTENSIONS_FILENAME = "defaultInputExtensions.xml";
    private static final String ROOT_PATH_MAP_FILENAME = "rootPaths.xml";

    public static BeanInstanceMap loadDefaultInstances(Path pathConfigurationDirectory) throws ExperimentExecutionException {
        Path pathHome = pathConfigurationDirectory.resolve(DEFAULT_INSTANCES_FILENAME).normalize();
        Path pathUser = HelperLoadAdditionalConfig.getAnchorUserDir().resolve(DEFAULT_INSTANCES_FILENAME).normalize();
        if (!pathHome.toFile().exists() && !pathUser.toFile().exists()) {
            throw new ExperimentExecutionException(String.format("Cannot find a config file for defaultBean instances, looking at:%n%s%n%s", pathHome, pathUser));
        }
        BeanInstanceMap map = new BeanInstanceMap();
        HelperLoadAdditionalConfig.addDefaultInstancesFromDirectory(pathHome, map);
        HelperLoadAdditionalConfig.addDefaultInstancesFromDirectory(pathUser, map);
        return map;
    }

    public static Optional<StringSetTrie> loadDefaultExtensions(Path pathConfigDirectory) throws ExperimentExecutionException {
        Path path = pathConfigDirectory.resolve(DEFAULT_EXTENSIONS_FILENAME).normalize();
        if (path.toFile().exists()) {
            try {
                StringSet setBean = (StringSet)BeanXMLLoader.loadBean((Path)path, (String)"bean");
                return Optional.of(new StringSetTrie((Collection)setBean.set()));
            }
            catch (BeanXMLException e) {
                throw new ExperimentExecutionException(String.format("An error occurred loading bean XML from %s", path), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private static void addDefaultInstancesFromDirectory(Path path, BeanInstanceMap addToMap) throws ExperimentExecutionException {
        if (path.toFile().exists()) {
            try {
                List listDefaults = (List)BeanXMLLoader.loadBean((Path)path, (String)"bean");
                addToMap.addFrom(listDefaults);
            }
            catch (BeanMisconfiguredException | BeanXMLException e) {
                throw new ExperimentExecutionException(String.format("An error occurred loading bean XML from %s", path), e);
            }
        }
    }

    public static RootPathMap loadRootPaths(Path pathConfigurationDirectory) throws ExperimentExecutionException {
        Path pathHome = pathConfigurationDirectory.resolve(ROOT_PATH_MAP_FILENAME).normalize();
        Path pathUser = HelperLoadAdditionalConfig.getAnchorUserDir().resolve(ROOT_PATH_MAP_FILENAME).normalize();
        HelperLoadAdditionalConfig.addRootPathsFromDir(pathHome, RootPathMap.instance());
        HelperLoadAdditionalConfig.addRootPathsFromDir(pathUser, RootPathMap.instance());
        return RootPathMap.instance();
    }

    private static void addRootPathsFromDir(Path path, RootPathMap addToMap) throws ExperimentExecutionException {
        if (path.toFile().exists()) {
            try {
                addToMap.addFromXmlFile(path);
            }
            catch (OperationFailedException e) {
                throw new ExperimentExecutionException(String.format("An error occurred adding a root-path from the XML file %s", path), (Throwable)e);
            }
        }
    }

    private static Path getAnchorUserDir() {
        Path currentUsersHomeDir = Paths.get(System.getProperty("user.home"), new String[0]);
        return currentUsersHomeDir.resolve(ANCHOR_USER_SUBDIR);
    }

    @Generated
    private HelperLoadAdditionalConfig() {
    }
}

