/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.UseDefaultManager;
import org.anchoranalysis.launcher.executor.selectparam.experiment.ExperimentFactory;
import org.anchoranalysis.launcher.executor.selectparam.path.InputFactory;
import org.anchoranalysis.launcher.executor.selectparam.path.OutputFactory;
import org.anchoranalysis.launcher.executor.selectparam.path.TaskFactory;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.InvalidPathArgumentException;
import org.apache.commons.cli.CommandLine;

public class SelectParamFactory {
    public static SelectParam<Optional<Path>> useDefault() {
        return new UseDefaultManager();
    }

    public static SelectParam<Optional<Path>> pathOrTaskNameOrDefault(CommandLine line, String optionName, Path tasksDirectory) {
        return SelectParamFactory.ifOptionOrDefault(line, optionName, args -> TaskFactory.pathOrTaskName(args, tasksDirectory));
    }

    public static SelectParam<Optional<Path>> inputSelectParam(CommandLine line) {
        try {
            return SelectParamFactory.ifOptionOrDefault(line, "i", InputFactory::pathOrDirectoryOrGlobOrExtension);
        }
        catch (InvalidPathArgumentException e) {
            throw e.toCommandLineException();
        }
    }

    public static SelectParam<Optional<Path>> outputSelectParam(CommandLine line) throws ExperimentExecutionException {
        if (line.hasOption("o") && line.hasOption("oo")) {
            throw new ExperimentExecutionException(String.format("Only one of command-line options -%s and -%s may be present, but both are!", "o", "oo"));
        }
        Optional<SelectParam<Optional<Path>>> selected = SelectParamFactory.ifOption(line, "oo", arg -> OutputFactory.pathOrDirectory(arg, true));
        if (selected.isPresent()) {
            return selected.get();
        }
        return SelectParamFactory.ifOptionOrDefault(line, "o", arg -> OutputFactory.pathOrDirectory(arg, false));
    }

    public static SelectParam<Path> experimentSelectParam(CommandLine line, Path defaultExperiment) throws ExperimentExecutionException {
        return ExperimentFactory.defaultExperimentOrCustom(line, defaultExperiment);
    }

    private static <E extends Exception> SelectParam<Optional<Path>> ifOptionOrDefault(CommandLine line, String optionName, CheckedFunction<String[], SelectParam<Optional<Path>>, E> func) throws E {
        return SelectParamFactory.ifOption(line, optionName, func).orElseGet(UseDefaultManager::new);
    }

    private static <E extends Exception> Optional<SelectParam<Optional<Path>>> ifOption(CommandLine line, String optionName, CheckedFunction<String[], SelectParam<Optional<Path>>, E> func) throws E {
        if (line.hasOption(optionName)) {
            return Optional.of((SelectParam)func.apply((Object)line.getOptionValues(optionName)));
        }
        return Optional.empty();
    }

    @Generated
    private SelectParamFactory() {
    }
}

