/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.experiment;

import java.nio.file.Path;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.PrettyPathConverter;

class UseExperimentPassedAsPath
implements SelectParam<Path> {
    private Path path;

    public UseExperimentPassedAsPath(Path path) {
        this.path = path;
    }

    @Override
    public Path select(ExecutionArguments executionArguments) throws ExperimentExecutionException {
        if (this.path.toFile().isDirectory()) {
            throw new ExperimentExecutionException("Please select a path to experiment FILE not a folder");
        }
        return this.path;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public String describe() throws ExperimentExecutionException {
        return String.format("experiment %s", PrettyPathConverter.prettyPath(this.path));
    }
}

