/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.path;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.launcher.CommandLineException;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.path.ExtensionHelper;
import org.anchoranalysis.launcher.executor.selectparam.path.UseAsCustomManager;
import org.anchoranalysis.launcher.executor.selectparam.path.UseAsExtension;
import org.anchoranalysis.launcher.executor.selectparam.path.UseAsGlob;
import org.anchoranalysis.launcher.executor.selectparam.path.UseDirectoryForManager;
import org.anchoranalysis.launcher.executor.selectparam.path.UseListFilesForManager;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.ArgumentConverter;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.InvalidPathArgumentException;

public class InputFactory {
    public static SelectParam<Optional<Path>> pathOrDirectoryOrGlobOrExtension(String[] arguments) throws InvalidPathArgumentException {
        Optional optional = OptionalUtilities.orFlatSupplier((CheckedSupplier[])new CheckedSupplier[]{() -> InputFactory.checkWildcard(arguments), () -> InputFactory.checkXmlExtension(arguments), () -> InputFactory.checkFileExtension(arguments), () -> InputFactory.checkDirectory(InputFactory.pathFromArguments(arguments))});
        return (SelectParam)OptionalUtilities.orElseGet((Optional)optional, () -> new UseListFilesForManager(InputFactory.pathFromArguments(arguments)));
    }

    private static Optional<SelectParam<Optional<Path>>> checkWildcard(String[] arguments) throws InvalidPathArgumentException {
        return InputFactory.check(Arrays.stream(arguments).anyMatch(s -> s.contains("*")), arguments.length == 1, () -> new UseAsGlob(arguments[0]), "Only a single wildcard argument is permitted to -i");
    }

    private static Optional<SelectParam<Optional<Path>>> checkFileExtension(String[] args) throws InvalidPathArgumentException {
        return InputFactory.check(Arrays.stream(args).anyMatch(ExtensionHelper::isFileExtension), Arrays.stream(args).allMatch(ExtensionHelper::isFileExtension), () -> new UseAsExtension(args), "If a file-extension (e.g. .png) is specified, all other arguments to -i must also be file-extensions");
    }

    private static Optional<SelectParam<Optional<Path>>> checkXmlExtension(String[] args) throws InvalidPathArgumentException {
        return InputFactory.check(Arrays.stream(args).anyMatch(ExtensionHelper::hasXmlExtension), args.length == 1, () -> new UseAsCustomManager(ArgumentConverter.pathFromArgument(args[0])), "Only a single BeanXML argument is permitted after -i (i.e. with a path with a .xml extension)");
    }

    private static Optional<SelectParam<Optional<Path>>> checkDirectory(List<Path> paths) throws InvalidPathArgumentException {
        return InputFactory.check(paths.stream().anyMatch(path -> path.toFile().isDirectory()), paths.size() == 1, () -> new UseDirectoryForManager((Path)paths.get(0), true, true), String.join((CharSequence)System.lineSeparator(), "with -i, please specify either:", "\ta single directory", "\tOR one or more files", "\tOR a file extension (with a leading period)", "\tBUT NOT multiple directories.", "Perhaps your wildcard match is ill-specified?"));
    }

    private static <T> Optional<T> check(boolean condition1, boolean condition2, CheckedSupplier<T, InvalidPathArgumentException> supplier, String errorMessage) throws InvalidPathArgumentException {
        if (condition1) {
            if (condition2) {
                return Optional.of(supplier.get());
            }
            throw new CommandLineException(errorMessage);
        }
        return Optional.empty();
    }

    private static List<Path> pathFromArguments(String[] args) throws InvalidPathArgumentException {
        return FunctionalList.mapToList((Object[])args, InvalidPathArgumentException.class, ArgumentConverter::pathFromArgument);
    }

    @Generated
    private InputFactory() {
    }
}

