/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.path;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.anchoranalysis.core.collection.StringSetTrie;
import org.anchoranalysis.core.format.FormatExtensions;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;

class UseAsExtension
implements SelectParam<Optional<Path>> {
    private StringSetTrie extensions;

    public UseAsExtension(String[] extensionsUnsplit) {
        this.extensions = UseAsExtension.splitAndNormalize(extensionsUnsplit);
    }

    @Override
    public Optional<Path> select(ExecutionArguments executionArguments) {
        executionArguments.inputContextParameters().assignInputFilterExtensions(this.extensions);
        return Optional.empty();
    }

    @Override
    public String describe() throws ExperimentExecutionException {
        return String.join((CharSequence)", ", this.extensions.values());
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    private static StringSetTrie splitAndNormalize(String[] extensionsUnsplit) {
        StringSetTrie trie = new StringSetTrie();
        Arrays.stream(extensionsUnsplit).flatMap(str -> UseAsExtension.splitAsStream(str, ",")).map(String::trim).map(FormatExtensions::removeAnyLeadingPeriod).map(FormatExtensions::normalizeToLowerCase).forEach(arg_0 -> ((StringSetTrie)trie).add(arg_0));
        return trie;
    }

    private static Stream<String> splitAsStream(String strToSplit, String splitRegEx) {
        return Arrays.stream(strToSplit.split(splitRegEx));
    }
}

