/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.run.tasks;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.core.format.NonImageFileFormat;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.bean.path.matcher.MatchGlob;

class FindTasks {
    private static final MatchGlob MATCHER = new MatchGlob("**." + NonImageFileFormat.XML.getDefaultExtension());
    private static final String IGNORE_SUBDIRECTORY = "include/";

    public static Stream<String> taskNames(Path tasksDirectory) throws InputReadFailedException {
        Path directoryNormalized = tasksDirectory.normalize().toAbsolutePath();
        Stream<Path> taskPaths = FindTasks.allXmlFiles(directoryNormalized).stream().map(File::toPath);
        Stream<String> taskNames = taskPaths.map(path -> FindTasks.taskIdentifier(directoryNormalized, path));
        return taskNames.filter(name -> !name.startsWith(IGNORE_SUBDIRECTORY));
    }

    private static Collection<File> allXmlFiles(Path tasksDirectory) throws InputReadFailedException {
        return MATCHER.matchingFiles(tasksDirectory, true, true, true, Optional.empty(), Optional.empty());
    }

    private static String taskIdentifier(Path tasksDirectory, Path path) {
        Path relative = FindTasks.removeLeadingPeriods(tasksDirectory.relativize(path));
        String unixStyle = FilePathToUnixStyleConverter.toStringUnixStyle((Path)relative);
        return FindTasks.removeXmlExtension(unixStyle, NonImageFileFormat.XML.getDefaultExtension());
    }

    private static String removeXmlExtension(String identifier, String extension) {
        Preconditions.checkArgument((boolean)identifier.endsWith(extension));
        return identifier.substring(0, identifier.length() - extension.length() - 1);
    }

    private static Path removeLeadingPeriods(Path path) {
        Preconditions.checkArgument((!path.isAbsolute() ? 1 : 0) != 0);
        Preconditions.checkArgument((path.getNameCount() > 0 ? 1 : 0) != 0);
        int firstNonPeriod = -1;
        for (int i = 0; i < path.getNameCount(); ++i) {
            String element = path.getName(i).toString();
            if (element.equals(".") || element.equals("..")) continue;
            firstNonPeriod = i;
            break;
        }
        Preconditions.checkArgument((firstNonPeriod != -1 ? 1 : 0) != 0);
        return path.subpath(firstNonPeriod, path.getNameCount());
    }

    @Generated
    private FindTasks() {
    }
}

