/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.arithmetic;

import java.io.Serializable;

public class RunningSum
implements Serializable {
    private static final long serialVersionUID = -2147459521030056604L;
    private double sum = 0.0;
    private long count = 0L;

    public double mean() {
        return this.mean(Double.NaN);
    }

    public double mean(double valueIfCountZero) {
        if (this.count != 0L) {
            return this.sum / (double)this.count;
        }
        return valueIfCountZero;
    }

    public double meanAndReset() {
        double mean = this.mean();
        this.reset();
        return mean;
    }

    public void reset() {
        this.sum = 0.0;
        this.count = 0L;
    }

    public void increment(double sumIncrement) {
        this.sum += sumIncrement;
        ++this.count;
    }

    public void increment(double sumIncrement, long countIncrement) {
        this.sum += sumIncrement;
        this.count += countIncrement;
    }

    public void increment(RunningSum runningSum) {
        this.sum += runningSum.getSum();
        this.count += runningSum.getCount();
    }

    public RunningSum duplicate() {
        RunningSum out = new RunningSum();
        out.sum = this.sum;
        out.count = this.count;
        return out;
    }

    public void add(RunningSum toAdd) {
        this.sum += toAdd.sum;
        this.count += toAdd.count;
    }

    public RunningSum() {
    }

    public RunningSum(double sum, long count) {
        this.sum = sum;
        this.count = count;
    }

    public double getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }
}

