/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.equation;

import org.anchoranalysis.core.exception.OperationFailedException;

public class QuadraticEquationSolver {
    private static final double VERY_SMALL_ERROR = -0.001;

    public static QuadraticRoots solveQuadraticEquation(double a, double b, double c) throws OperationFailedException {
        double common = b * b - 4.0 * a * c;
        if (common > -0.001 && common < 0.0) {
            common = 0.0;
        }
        if (common < 0.0) {
            throw new OperationFailedException(String.format("Complex roots returned: common=%f", common));
        }
        double commonSquareRoot = Math.sqrt(common);
        double div = 2.0 * a;
        double root1 = (-b + commonSquareRoot) / div;
        double root2 = (-b - commonSquareRoot) / div;
        return new QuadraticRoots(root1, root2);
    }

    private QuadraticEquationSolver() {
    }

    public static class QuadraticRoots {
        private double root1;
        private double root2;

        public QuadraticRoots(double root1, double root2) {
            this.root1 = root1;
            this.root2 = root2;
        }

        public double getRoot1() {
            return this.root1;
        }

        public double getRoot2() {
            return this.root2;
        }

        public void setRoot1(double root1) {
            this.root1 = root1;
        }

        public void setRoot2(double root2) {
            this.root2 = root2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QuadraticRoots)) {
                return false;
            }
            QuadraticRoots other = (QuadraticRoots)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getRoot1(), other.getRoot1()) != 0) {
                return false;
            }
            return Double.compare(this.getRoot2(), other.getRoot2()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof QuadraticRoots;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $root1 = Double.doubleToLongBits(this.getRoot1());
            result = result * 59 + (int)($root1 >>> 32 ^ $root1);
            long $root2 = Double.doubleToLongBits(this.getRoot2());
            result = result * 59 + (int)($root2 >>> 32 ^ $root2);
            return result;
        }

        public String toString() {
            return "QuadraticEquationSolver.QuadraticRoots(root1=" + this.getRoot1() + ", root2=" + this.getRoot2() + ")";
        }
    }
}

