/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.optimization;

import java.util.function.IntPredicate;

public class SearchClosestValueMonoticallyIncreasing {
    private final double target;
    private final ValueFunction function;
    private final IntPredicate boundUpper;

    public SearchClosestValueMonoticallyIncreasing(double target, ValueFunction function) {
        this.target = target;
        this.function = function;
        this.boundUpper = value -> false;
    }

    public int findOptimalInput(int boundLower) {
        int boundPrevious = boundLower;
        int bound = boundLower * 2;
        double height = this.function.calculate(bound);
        while (height < this.target && !this.boundUpper.test(bound)) {
            boundPrevious = bound;
            height = this.function.calculate(bound *= 2);
        }
        return this.binarySearch(boundPrevious, bound);
    }

    private int binarySearch(int lower, int upper) {
        if (lower == upper || lower == upper - 1) {
            return lower;
        }
        int mean = (upper + lower) / 2;
        double outputMean = this.function.calculate(mean);
        if (outputMean > this.target || this.boundUpper.test(mean)) {
            return this.binarySearch(lower, mean);
        }
        return this.binarySearch(mean, upper);
    }

    public SearchClosestValueMonoticallyIncreasing(double target, ValueFunction function, IntPredicate boundUpper) {
        this.target = target;
        this.function = function;
        this.boundUpper = boundUpper;
    }

    @FunctionalInterface
    public static interface ValueFunction {
        public double calculate(int var1);
    }
}

