/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.statistics;

import com.google.common.base.Preconditions;

class VarianceCalculatorHelper {
    public static double calculateVariance(double sum, double sumSquares, long count) {
        Preconditions.checkArgument((sumSquares >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((sum >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0);
        double second = Math.pow(sum, 2.0) / (double)count;
        double val = (sumSquares - second) / (double)count;
        assert (val >= 0.0);
        return val;
    }

    private VarianceCalculatorHelper() {
    }
}

