/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.statistics;

import org.anchoranalysis.math.statistics.VarianceCalculatorHelper;

public class VarianceCalculatorLong {
    private long sum = 0L;
    private long sumSquares = 0L;
    private long count = 0L;

    public void add(int value) {
        long valueLong = value;
        this.sum += valueLong;
        this.sumSquares += valueLong * valueLong;
        ++this.count;
    }

    public void add(int value, int instances) {
        long addSum = (long)instances * (long)value;
        long addSumSquares = addSum * (long)value;
        assert (addSum >= 0L);
        assert (addSumSquares >= 0L);
        this.sum += addSum;
        this.sumSquares += addSumSquares;
        this.count += (long)instances;
    }

    public VarianceCalculatorLong subtract(VarianceCalculatorLong toSubtract) {
        return new VarianceCalculatorLong(this.sum - toSubtract.sum, this.sumSquares - toSubtract.sumSquares, this.count - toSubtract.count);
    }

    public double mean() {
        return (double)this.sum / (double)this.count;
    }

    public double variance() {
        return VarianceCalculatorHelper.calculateVariance(this.sum, this.sumSquares, this.count);
    }

    public VarianceCalculatorLong(long sum, long sumSquares, long count) {
        this.sum = sum;
        this.sumSquares = sumSquares;
        this.count = count;
    }

    public VarianceCalculatorLong() {
    }

    public long getCount() {
        return this.count;
    }
}

