/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.statistics.moment;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.anchoranalysis.math.statistics.moment.EigenvalueAndVector;

class EigenValueDecompose {
    public static List<EigenvalueAndVector> apply(DoubleMatrix2D covarianceMatrix, boolean sortAscending) {
        List<EigenvalueAndVector> list = EigenValueDecompose.eigenValueDecompose(covarianceMatrix);
        EigenValueDecompose.sortList(list, sortAscending);
        return list;
    }

    private static List<EigenvalueAndVector> eigenValueDecompose(DoubleMatrix2D secondMoments) {
        ArrayList<EigenvalueAndVector> list = new ArrayList<EigenvalueAndVector>(3);
        EigenvalueDecomposition ed = new EigenvalueDecomposition(secondMoments);
        DoubleMatrix1D evals = ed.getRealEigenvalues();
        for (int i = 0; i < 3; ++i) {
            list.add(new EigenvalueAndVector(evals.get(i), ed.getV().viewColumn(i)));
        }
        return list;
    }

    private static <T extends Comparable<T>> void sortList(List<T> list, boolean sortOrder) {
        if (sortOrder) {
            Collections.sort(list);
        } else {
            Collections.sort(list, Collections.reverseOrder());
        }
    }

    private EigenValueDecompose() {
    }
}

