/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.statistics.moment;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Statistic;
import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.math.statistics.moment.EigenValueDecompose;
import org.anchoranalysis.math.statistics.moment.EigenvalueAndVector;

public class ImageMoments {
    private List<EigenvalueAndVector> list;
    private double[] mean = new double[3];

    public ImageMoments(DoubleMatrix2D matrixPoints, boolean suppressZ, boolean sortAscending) {
        this.mean = ImageMoments.calculateFirstMoments(matrixPoints);
        this.list = EigenValueDecompose.apply(ImageMoments.calculateSecondMoments(matrixPoints, suppressZ), sortAscending);
    }

    public EigenvalueAndVector get(int axis) {
        return this.list.get(axis);
    }

    public double getMean(int axis) {
        return this.mean[axis];
    }

    public void removeClosestToUnitZ() {
        double zMax = Double.NEGATIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < 3; ++i) {
            double zVal = this.list.get(i).getEigenvector().get(2);
            if (!(zVal > zMax)) continue;
            zMax = zVal;
            index = i;
        }
        assert (index != -1);
        this.list.remove(index);
    }

    public ImageMoments duplicate() {
        ImageMoments out = new ImageMoments();
        out.list = new ArrayList<EigenvalueAndVector>();
        for (int i = 0; i < 3; ++i) {
            out.list.add(this.list.get(i).duplicate());
        }
        return out;
    }

    private static double[] calculateFirstMoments(DoubleMatrix2D matrixPoints) {
        double[] mean = new double[3];
        for (int i = 0; i < 3; ++i) {
            mean[i] = matrixPoints.viewColumn(i).zSum() / (double)matrixPoints.rows();
        }
        return mean;
    }

    private static DoubleMatrix2D calculateSecondMoments(DoubleMatrix2D matrixPoints, boolean suppressZ) {
        DoubleMatrix2D secondMoments = Statistic.covariance((DoubleMatrix2D)matrixPoints);
        if (suppressZ) {
            secondMoments.set(2, 0, 0.0);
            secondMoments.set(2, 1, 0.0);
            secondMoments.set(0, 2, 0.0);
            secondMoments.set(1, 2, 0.0);
        }
        return secondMoments;
    }

    private ImageMoments() {
    }
}

