/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.histogram;

import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.math.histogram.Histogram;

public class HistogramStatistics {
    public static double coefficientOfVariation(Histogram histogram) throws OperationFailedException {
        double mean = histogram.mean();
        if (mean == 0.0) {
            throw new OperationFailedException("The mean is 0 so the coefficient-of-variation is undefined");
        }
        return histogram.standardDeviation() / mean;
    }

    public static double skewness(Histogram histogram) throws OperationFailedException {
        long count = histogram.getTotalCount();
        double mean = histogram.mean();
        double stdDev = histogram.standardDeviation();
        long firstTerm = histogram.calculateSumCubes() / count;
        double secondTerm = -3.0 * mean * stdDev * stdDev;
        double thirdTerm = mean * mean * mean;
        double denominator = stdDev * stdDev * stdDev;
        return ((double)firstTerm + secondTerm + thirdTerm) / denominator;
    }

    public static double kurtosis(Histogram histogram) throws OperationFailedException {
        double histogramMean = histogram.mean();
        double fourthMomentAboutMean = histogram.mean(4.0, histogramMean);
        double varianceSquared = Math.pow(histogram.variance(), 2.0);
        if (varianceSquared == 0.0) {
            throw new OperationFailedException("Kurtosis is undefined as there is 0 variance");
        }
        return fourthMomentAboutMean / varianceSquared;
    }

    @Generated
    private HistogramStatistics() {
    }
}

