/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.statistics;

import lombok.Generated;
import org.anchoranalysis.math.statistics.VarianceCalculatorHelper;

public class VarianceCalculatorDouble {
    private double sum = 0.0;
    private double sumSquares = 0.0;
    private long count = 0L;

    public void add(double value) {
        this.sum += value;
        this.sumSquares += value * value;
        ++this.count;
    }

    public VarianceCalculatorDouble subtract(VarianceCalculatorDouble toSubtract) {
        return new VarianceCalculatorDouble(this.sum - toSubtract.sum, this.sumSquares - toSubtract.sumSquares, this.count - toSubtract.count);
    }

    public double mean() {
        return this.sum / (double)this.count;
    }

    public double variance() {
        return VarianceCalculatorHelper.calculateVariance(this.sum, this.sumSquares, this.count);
    }

    @Generated
    public VarianceCalculatorDouble(double sum, double sumSquares, long count) {
        this.sum = sum;
        this.sumSquares = sumSquares;
        this.count = count;
    }

    @Generated
    public VarianceCalculatorDouble() {
    }

    @Generated
    public long getCount() {
        return this.count;
    }
}

