/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.math.statistics.moment;

import cern.colt.matrix.DoubleMatrix1D;
import lombok.Generated;

public final class EigenvalueAndVector
implements Comparable<EigenvalueAndVector> {
    private final double eigenvalue;
    private final DoubleMatrix1D eigenvector;

    @Override
    public int compareTo(EigenvalueAndVector other) {
        return Double.compare(this.eigenvalue, other.eigenvalue);
    }

    public EigenvalueAndVector duplicate() {
        return new EigenvalueAndVector(this.eigenvalue, this.eigenvector.copy());
    }

    @Generated
    public EigenvalueAndVector(double eigenvalue, DoubleMatrix1D eigenvector) {
        this.eigenvalue = eigenvalue;
        this.eigenvector = eigenvector;
    }

    @Generated
    public double getEigenvalue() {
        return this.eigenvalue;
    }

    @Generated
    public DoubleMatrix1D getEigenvector() {
        return this.eigenvector;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EigenvalueAndVector)) {
            return false;
        }
        EigenvalueAndVector other = (EigenvalueAndVector)o;
        if (Double.compare(this.getEigenvalue(), other.getEigenvalue()) != 0) {
            return false;
        }
        DoubleMatrix1D this$eigenvector = this.getEigenvector();
        DoubleMatrix1D other$eigenvector = other.getEigenvector();
        return !(this$eigenvector == null ? other$eigenvector != null : !this$eigenvector.equals(other$eigenvector));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eigenvalue = Double.doubleToLongBits(this.getEigenvalue());
        result = result * 59 + (int)($eigenvalue >>> 32 ^ $eigenvalue);
        DoubleMatrix1D $eigenvector = this.getEigenvector();
        result = result * 59 + ($eigenvector == null ? 43 : $eigenvector.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EigenvalueAndVector(eigenvalue=" + this.getEigenvalue() + ", eigenvector=" + String.valueOf(this.getEigenvector()) + ")";
    }
}

