/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.addcriteria;

import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteria;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteriaPair;
import org.anchoranalysis.mpp.feature.addcriteria.IncludeMarksFailureException;
import org.anchoranalysis.mpp.feature.energy.EnergyPair;
import org.anchoranalysis.mpp.feature.energy.EnergyTotal;
import org.anchoranalysis.mpp.feature.input.FeatureInputPairMemo;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;
import org.anchoranalysis.mpp.pair.MarkPair;

public class AddCriteriaEnergyPair
implements AddCriteria<EnergyPair> {
    private FeatureList<FeatureInputPairMemo> energyPairs;
    private AddCriteriaPair pairAddCriteria;
    private Optional<FeatureList<FeatureInputPairMemo>> featuresAddCriteria;

    public AddCriteriaEnergyPair(FeatureList<FeatureInputPairMemo> energyPairs, AddCriteriaPair pairAddCriteria) throws InitializeException {
        this.energyPairs = energyPairs;
        this.pairAddCriteria = pairAddCriteria;
        try {
            this.featuresAddCriteria = this.pairAddCriteria.orderedListOfFeatures();
        }
        catch (CreateException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    @Override
    public Optional<FeatureList<FeatureInputPairMemo>> orderedListOfFeatures() throws CreateException {
        return Optional.of(this.energyPairs.shallowDuplicate().append(this.featuresAddCriteria));
    }

    @Override
    public Optional<EnergyPair> generateEdge(VoxelizedMarkMemo mark1, VoxelizedMarkMemo mark2, EnergyStack energyStack, Optional<FeatureCalculatorMulti<FeatureInputPairMemo>> session, boolean do3D) throws CreateException {
        boolean calculate = false;
        try {
            if (this.pairAddCriteria.includeMarks(mark1, mark2, energyStack.dimensions(), session, do3D)) {
                calculate = true;
            }
        }
        catch (IncludeMarksFailureException e) {
            throw new CreateException((Throwable)((Object)e));
        }
        if (calculate) {
            try {
                FeatureInputPairMemo input = new FeatureInputPairMemo(mark1, mark2, energyStack);
                ResultsVector results = session.orElseThrow(() -> new NamedFeatureCalculateException("No feature-evaluator exists")).calculate((FeatureInput)input, this.energyPairs);
                MarkPair pair = new MarkPair(mark1.getMark(), mark2.getMark());
                return Optional.of(new EnergyPair((MarkPair<Mark>)pair, new EnergyTotal(results.total())));
            }
            catch (NamedFeatureCalculateException e) {
                throw new CreateException((Throwable)e);
            }
        }
        return Optional.empty();
    }
}

