/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.addcriteria;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteriaPair;
import org.anchoranalysis.mpp.feature.addcriteria.IncludeMarksFailureException;
import org.anchoranalysis.mpp.feature.input.FeatureInputPairMemo;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;
import org.anchoranalysis.spatial.box.BoundingBox;

public class BoundingBoxIntersection
extends AddCriteriaPair {
    @BeanField
    private boolean suppressZ = false;

    @Override
    public boolean includeMarks(VoxelizedMarkMemo mark1, VoxelizedMarkMemo mark2, Dimensions dimensions, Optional<FeatureCalculatorMulti<FeatureInputPairMemo>> session, boolean do3D) throws IncludeMarksFailureException {
        return this.boxFor(mark1.getMark(), dimensions).intersection().existsWith(this.boxFor(mark2.getMark(), dimensions));
    }

    @Override
    public Optional<FeatureList<FeatureInputPairMemo>> orderedListOfFeatures() {
        return Optional.empty();
    }

    private BoundingBox boxFor(Mark mark, Dimensions dimensions) {
        BoundingBox box = mark.boxAllRegions(dimensions);
        if (this.suppressZ) {
            return box.flattenZ();
        }
        return box;
    }

    public boolean isSuppressZ() {
        return this.suppressZ;
    }

    public void setSuppressZ(boolean suppressZ) {
        this.suppressZ = suppressZ;
    }
}

