/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.addcriteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.graph.GraphWithPayload;
import org.anchoranalysis.core.graph.TypedEdge;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.random.RandomNumberGenerator;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteria;
import org.anchoranalysis.mpp.feature.input.FeatureInputPairMemo;
import org.anchoranalysis.mpp.feature.mark.MemoList;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.mpp.mark.UpdateMarkSetException;
import org.anchoranalysis.mpp.mark.voxelized.memo.MemoForIndex;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;
import org.anchoranalysis.mpp.pair.RandomCollection;

public class RandomCollectionWithAddCriteria<T>
extends RandomCollection<T> {
    private GraphWithPayload<Mark, T> graph;
    @BeanField
    private Class<?> pairTypeClass;
    @BeanField
    private AddCriteria<T> addCriteria;
    private boolean hasInit = false;
    private EnergyStack energyStack;
    private Logger logger;
    private SharedFeatures sharedFeatures;

    public RandomCollectionWithAddCriteria(Class<?> pairTypeClass) {
        this.pairTypeClass = pairTypeClass;
        this.graph = new GraphWithPayload(true);
    }

    public RandomCollectionWithAddCriteria<T> shallowCopy() {
        RandomCollectionWithAddCriteria<T> out = new RandomCollectionWithAddCriteria<T>(this.pairTypeClass);
        out.graph = this.graph.shallowCopy();
        out.addCriteria = this.addCriteria;
        out.energyStack = this.energyStack;
        out.hasInit = this.hasInit;
        out.logger = this.logger;
        out.sharedFeatures = this.sharedFeatures;
        return out;
    }

    public RandomCollectionWithAddCriteria<T> deepCopy() {
        RandomCollectionWithAddCriteria<T> out = new RandomCollectionWithAddCriteria<T>(this.pairTypeClass);
        out.graph = this.graph.shallowCopy();
        out.addCriteria = this.addCriteria;
        out.energyStack = this.energyStack;
        out.hasInit = this.hasInit;
        out.logger = this.logger;
        out.sharedFeatures = this.sharedFeatures;
        return out;
    }

    public void initUpdatableMarks(MemoForIndex marks, EnergyStack stack, Logger logger, SharedFeatures sharedFeatures) throws InitializeException {
        this.logger = logger;
        this.sharedFeatures = sharedFeatures;
        try {
            this.graph = new GraphWithPayload(true);
            for (int i = 0; i < marks.size(); ++i) {
                this.graph.addVertex((Object)marks.getMemoForIndex(i).getMark());
            }
            Optional features = this.addCriteria.orderedListOfFeatures();
            Optional session = OptionalUtilities.map(features, f -> FeatureSession.with((FeatureList)f, (FeatureInitialization)new FeatureInitialization(stack.getParameters()), (SharedFeatures)sharedFeatures, (Logger)logger));
            this.initGraph(marks, stack, session);
            this.hasInit = true;
            this.energyStack = stack;
        }
        catch (CreateException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public void add(MemoForIndex marksExisting, VoxelizedMarkMemo newMark) throws UpdateMarkSetException {
        this.checkInit();
        try {
            this.graph.addVertex((Object)newMark.getMark());
            this.calculatePairsForMark(marksExisting, newMark, this.energyStack);
        }
        catch (CreateException e) {
            throw new UpdateMarkSetException((Exception)((Object)e));
        }
    }

    public void exchange(MemoForIndex memo, VoxelizedMarkMemo oldMark, int indexOldMark, VoxelizedMarkMemo newMark) throws UpdateMarkSetException {
        this.checkInit();
        MemoList memoList = new MemoList();
        memoList.addAll(memo);
        this.remove(memo, oldMark);
        memoList.remove(indexOldMark);
        this.add(memoList, newMark);
    }

    public void remove(MemoForIndex marksExisting, VoxelizedMarkMemo mark) throws UpdateMarkSetException {
        this.checkInit();
        try {
            this.graph.removeVertex((Object)mark.getMark());
        }
        catch (OperationFailedException e) {
            throw new UpdateMarkSetException((Exception)((Object)e));
        }
    }

    public Set<T> createPairsUnique() {
        HashSet<Object> setOut = new HashSet<Object>();
        for (TypedEdge<Mark, T> pair : this.pairsMaybeDuplicates()) {
            setOut.add(pair.getPayload());
        }
        return setOut;
    }

    public Collection<TypedEdge<Mark, T>> getPairsFor(Mark mark) {
        return this.graph.outgoingEdgesFor((Object)mark);
    }

    public boolean containsMark(Mark mark) {
        return this.graph.containsVertex((Object)mark);
    }

    public Collection<Mark> getMarks() {
        return this.graph.vertices();
    }

    public boolean isMarksSpan(MarkCollection marks) {
        for (int i = 0; i < marks.size(); ++i) {
            if (this.containsMark(marks.get(i))) continue;
            return false;
        }
        for (Mark m : this.getMarks()) {
            if (marks.indexOf(m) != -1) continue;
            return false;
        }
        return true;
    }

    public T sampleRandomPairNonUniform(RandomNumberGenerator randomNumberGenerator) {
        int count = this.graph.edgesMaybeDuplicates().size();
        if (count == 0) {
            throw new AnchorFriendlyRuntimeException("No edges exist to sample from");
        }
        int index = randomNumberGenerator.sampleIntFromRange(count);
        int i = 0;
        for (TypedEdge<Mark, T> edge : this.pairsMaybeDuplicates()) {
            if (i++ != index) continue;
            return (T)edge.getPayload();
        }
        throw new AnchorFriendlyRuntimeException("Invalid index chosen for randomPair");
    }

    private void initGraph(MemoForIndex marks, EnergyStack stack, Optional<FeatureCalculatorMulti<FeatureInputPairMemo>> session) throws CreateException {
        for (int i = 0; i < marks.size(); ++i) {
            VoxelizedMarkMemo srcMark = marks.getMemoForIndex(i);
            for (int j = 0; j < i; ++j) {
                VoxelizedMarkMemo destMark = marks.getMemoForIndex(j);
                this.addCriteria.generateEdge(srcMark, destMark, stack, session, stack.dimensions().z() > 1).ifPresent(pair -> this.graph.addEdge((Object)srcMark.getMark(), (Object)destMark.getMark(), pair));
            }
        }
    }

    private void calculatePairsForMark(MemoForIndex memos, VoxelizedMarkMemo newMark, EnergyStack energyStack) throws CreateException {
        Optional session;
        try {
            session = OptionalUtilities.map(this.addCriteria.orderedListOfFeatures(), f -> FeatureSession.with((FeatureList)f, (FeatureInitialization)new FeatureInitialization(energyStack.getParameters()), (SharedFeatures)this.sharedFeatures, (Logger)this.logger));
        }
        catch (InitializeException e) {
            throw new CreateException((Throwable)e);
        }
        for (int i = 0; i < memos.size(); ++i) {
            VoxelizedMarkMemo otherMark = memos.getMemoForIndex(i);
            if (otherMark.getMark().equals(newMark.getMark())) continue;
            this.addCriteria.generateEdge(otherMark, newMark, energyStack, session, energyStack.dimensions().z() > 1).ifPresent(pair -> this.graph.addEdge((Object)otherMark.getMark(), (Object)newMark.getMark(), pair));
        }
    }

    private Collection<TypedEdge<Mark, T>> pairsMaybeDuplicates() {
        return this.graph.edgesMaybeDuplicates();
    }

    private void checkInit() throws UpdateMarkSetException {
        if (!this.hasInit) {
            throw new UpdateMarkSetException("object has not been initialized");
        }
    }

    public Class<?> getPairTypeClass() {
        return this.pairTypeClass;
    }

    public void setPairTypeClass(Class<?> pairTypeClass) {
        this.pairTypeClass = pairTypeClass;
    }

    public AddCriteria<T> getAddCriteria() {
        return this.addCriteria;
    }

    public void setAddCriteria(AddCriteria<T> addCriteria) {
        this.addCriteria = addCriteria;
    }
}

