/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.energy.marks;

import java.io.Serializable;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.mpp.feature.energy.marks.MarksWithTotalEnergy;
import org.anchoranalysis.mpp.feature.energy.saved.EnergySavedAll;
import org.anchoranalysis.mpp.feature.energy.saved.EnergySavedIndividual;
import org.anchoranalysis.mpp.feature.energy.saved.EnergySavedPairs;
import org.anchoranalysis.mpp.feature.energy.scheme.EnergySchemeWithSharedFeatures;
import org.anchoranalysis.mpp.feature.mark.EnergyMemoList;
import org.anchoranalysis.mpp.feature.mark.MemoList;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.mpp.mark.UpdateMarkSetException;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;

public class MarksWithEnergyBreakdown
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MarksWithTotalEnergy marks;
    private EnergySavedIndividual individual;
    private transient EnergySavedPairs pair;
    private transient EnergySavedAll all;

    public MarksWithEnergyBreakdown(MarksWithTotalEnergy marks) {
        this.marks = marks;
    }

    public void initialize() throws NamedFeatureCalculateException {
        this.individual = new EnergySavedIndividual();
        try {
            this.pair = new EnergySavedPairs(this.marks.getEnergyScheme().createAddCriteria());
            this.all = new EnergySavedAll();
        }
        catch (CreateException e) {
            throw new NamedFeatureCalculateException((Exception)((Object)e));
        }
    }

    public void assertValid() {
        if (this.individual != null) {
            this.individual.assertValid();
        }
        if (this.pair != null) {
            this.pair.assertValid();
        }
        if (this.individual != null && this.pair != null) assert (Math.abs(this.marks.getEnergyTotal() - this.individual.getEnergyTotal() - this.pair.getEnergyTotal()) < 0.001);
    }

    public MarksWithTotalEnergy getMarksWithTotalEnergy() {
        return this.marks;
    }

    public void updateTotal(EnergyMemoList pxlMarkMemoList, EnergyStackWithoutParameters stack) throws NamedFeatureCalculateException {
        this.all.calc(pxlMarkMemoList, this.marks.getEnergyScheme(), stack);
        double total = this.individual.getEnergyTotal() + this.pair.getEnergyTotal() + this.all.getEnergyTotal();
        assert (!Double.isNaN(total));
        this.marks.setEnergyTotal(total);
    }

    public MarksWithEnergyBreakdown shallowCopy() {
        return new MarksWithEnergyBreakdown(this.marks.shallowCopy(), this.individual.shallowCopy(), this.pair.shallowCopy(), this.all.shallowCopy());
    }

    public MarksWithEnergyBreakdown deepCopy() {
        return new MarksWithEnergyBreakdown(this.marks.deepCopy(), this.individual.deepCopy(), this.pair.deepCopy(), this.all.deepCopy());
    }

    public double getEnergyTotal() {
        return this.marks.getEnergyTotal();
    }

    public MarkCollection getMarks() {
        return this.marks.getMarks();
    }

    public EnergySchemeWithSharedFeatures getEnergyScheme() {
        return this.marks.getEnergyScheme();
    }

    public void add(EnergyMemoList wrapperInd, VoxelizedMarkMemo newPxlMarkMemo, EnergyStackWithoutParameters stack) throws NamedFeatureCalculateException {
        this.marks.add(newPxlMarkMemo);
        wrapperInd.add(this.getIndividual(), newPxlMarkMemo, stack, this.marks.getEnergyScheme());
        try {
            this.getPair().add(wrapperInd, newPxlMarkMemo);
        }
        catch (UpdateMarkSetException e) {
            throw new NamedFeatureCalculateException((Exception)((Object)e));
        }
        this.updateTotal(wrapperInd, stack);
    }

    public void remove(EnergyMemoList wrapperInd, VoxelizedMarkMemo markToRemove, EnergyStackWithoutParameters stack) throws NamedFeatureCalculateException {
        int index = wrapperInd.getIndexForMemo(markToRemove);
        assert (index != -1);
        this.remove(wrapperInd, index, markToRemove, stack);
    }

    public void remove(EnergyMemoList wrapperInd, int index, VoxelizedMarkMemo markToRemove, EnergyStackWithoutParameters stack) throws NamedFeatureCalculateException {
        try {
            this.getPair().remove(wrapperInd, markToRemove);
            wrapperInd.remove(this.getIndividual(), index);
            this.remove(index);
            this.updateTotal(wrapperInd, stack);
        }
        catch (UpdateMarkSetException e) {
            throw new NamedFeatureCalculateException((Exception)((Object)e));
        }
    }

    public void removeTwo(EnergyMemoList wrapperInd, int index1, int index2, EnergyStackWithoutParameters energyStack) throws NamedFeatureCalculateException {
        VoxelizedMarkMemo memoRmv1 = wrapperInd.getMemoForIndex(index1);
        VoxelizedMarkMemo memoRmv2 = wrapperInd.getMemoForIndex(index2);
        wrapperInd.removeTwo(this.getIndividual(), index1, index2);
        MarkCollection newMarks = this.marks.getMarks().shallowCopy();
        MemoList memoList = new MemoList();
        memoList.addAll(wrapperInd);
        try {
            this.getPair().remove(memoList, memoRmv1);
            memoList.remove(memoRmv1);
            this.getPair().remove(memoList, memoRmv2);
        }
        catch (UpdateMarkSetException e) {
            throw new NamedFeatureCalculateException((Exception)((Object)e));
        }
        newMarks.removeTwo(index1, index2);
        this.marks.setMarks(newMarks);
        this.updateTotal(wrapperInd, energyStack);
    }

    public void exchange(EnergyMemoList wrapperInd, int index, VoxelizedMarkMemo newMark, EnergyStack energyStack) throws NamedFeatureCalculateException {
        Mark oldMark = this.marks.get(index);
        this.marks.exchange(index, newMark);
        VoxelizedMarkMemo newPxlMarkMemo = wrapperInd.exchange(this.getIndividual(), index, newMark, energyStack.withoutParameters(), this.marks.getEnergyScheme());
        try {
            VoxelizedMarkMemo oldPxlMarkMemo = wrapperInd.getMemoForMark(this.getMarks(), oldMark);
            this.getPair().exchange(wrapperInd, oldPxlMarkMemo, index, newPxlMarkMemo);
        }
        catch (UpdateMarkSetException e) {
            throw new NamedFeatureCalculateException((Exception)((Object)e));
        }
        assert (this.getPair().isMarksSpan(this.marks.getMarks()));
        this.updateTotal(wrapperInd, energyStack.withoutParameters());
        assert (this.marks.getEnergyTotal() - this.getIndividual().getEnergyTotal() - this.getPair().getEnergyTotal() < 1.0E-6);
    }

    public void remove(int index) {
        this.marks.remove(index);
    }

    public void exchange(int index, VoxelizedMarkMemo newMark) {
        this.marks.exchange(index, newMark);
    }

    public String toString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder("{");
        builder.append(String.format("size=%d, total=%e, ind=%e, pair=%e%n", this.getMarks().size(), this.getEnergyTotal(), this.getIndividual().getEnergyTotal(), this.getPair().getEnergyTotal()));
        builder.append(this.getIndividual().describeMarks(this.getMarks()));
        builder.append(this.getPair().toString());
        builder.append("}");
        builder.append(newLine);
        return builder.toString();
    }

    public final int size() {
        return this.marks.size();
    }

    public MarksWithEnergyBreakdown(MarksWithTotalEnergy marks, EnergySavedIndividual individual, EnergySavedPairs pair, EnergySavedAll all) {
        this.marks = marks;
        this.individual = individual;
        this.pair = pair;
        this.all = all;
    }

    public EnergySavedIndividual getIndividual() {
        return this.individual;
    }

    public EnergySavedPairs getPair() {
        return this.pair;
    }

    public EnergySavedAll getAll() {
        return this.all;
    }

    public void setAll(EnergySavedAll all) {
        this.all = all;
    }
}

