/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.energy.scheme;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteriaPair;
import org.anchoranalysis.mpp.feature.input.FeatureInputAllMemo;
import org.anchoranalysis.mpp.feature.input.FeatureInputPairMemo;
import org.anchoranalysis.mpp.feature.input.FeatureInputSingleMemo;

public class EnergyScheme {
    private final FeatureList<FeatureInputSingleMemo> elemInd;
    private final FeatureList<FeatureInputPairMemo> elemPair;
    private final FeatureList<FeatureInputAllMemo> elemAll;
    private final RegionMap regionMap;
    private final List<NamedBean<Feature<FeatureInputStack>>> listImageFeatures;
    private final AddCriteriaPair pairAddCriteria;
    private final Optional<DictionaryProvider> dictionary;

    public EnergyScheme(FeatureList<FeatureInputSingleMemo> elemInd, FeatureList<FeatureInputPairMemo> elemPair, FeatureList<FeatureInputAllMemo> elemAll, RegionMap regionMap, AddCriteriaPair pairAddCriteria) throws CreateException {
        this(elemInd, elemPair, elemAll, regionMap, pairAddCriteria, Optional.empty(), new ArrayList<NamedBean<Feature<FeatureInputStack>>>());
    }

    public EnergyScheme(FeatureList<FeatureInputSingleMemo> elemInd, FeatureList<FeatureInputPairMemo> elemPair, FeatureList<FeatureInputAllMemo> elemAll, RegionMap regionMap, AddCriteriaPair pairAddCriteria, Optional<DictionaryProvider> dictionary, List<NamedBean<Feature<FeatureInputStack>>> listImageFeatures) throws CreateException {
        this.elemInd = elemInd;
        this.elemPair = elemPair;
        this.elemAll = elemAll;
        this.regionMap = regionMap;
        this.pairAddCriteria = pairAddCriteria;
        this.dictionary = dictionary;
        this.listImageFeatures = listImageFeatures;
        this.checkAtLeastOneEnergyElement();
    }

    public Dictionary createDictionary() throws CreateException {
        if (this.dictionary.isPresent()) {
            try {
                return ((Dictionary)this.dictionary.get().get()).duplicate();
            }
            catch (ProvisionFailedException e) {
                throw new CreateException((Throwable)e);
            }
        }
        return new Dictionary();
    }

    private void checkAtLeastOneEnergyElement() throws CreateException {
        if (this.elemInd.size() + this.elemPair.size() + this.elemAll.size() == 0) {
            throw new CreateException("At least one Energy element must be specified");
        }
    }

    public <T extends FeatureInput> FeatureList<T> getElemByCliqueSize(int cliqueSize) {
        if (cliqueSize == 0) {
            return this.getElemIndAsFeatureList();
        }
        if (cliqueSize == 1) {
            return this.getElemPairAsFeatureList();
        }
        if (cliqueSize == -1) {
            return this.getElemAllAsFeatureList();
        }
        throw new AnchorImpossibleSituationException();
    }

    public FeatureList<FeatureInputSingleMemo> getElemIndAsFeatureList() {
        return this.elemInd;
    }

    public FeatureList<FeatureInputPairMemo> getElemPairAsFeatureList() {
        return this.elemPair;
    }

    public FeatureList<FeatureInputAllMemo> getElemAllAsFeatureList() {
        return this.elemAll;
    }

    public AddCriteriaPair getPairAddCriteria() {
        return this.pairAddCriteria;
    }

    public List<NamedBean<Feature<FeatureInputStack>>> getListImageFeatures() {
        return this.listImageFeatures;
    }

    public RegionMap getRegionMap() {
        return this.regionMap;
    }
}

