/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.energy.scheme;

import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteriaEnergyPair;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteriaPair;
import org.anchoranalysis.mpp.feature.energy.EnergyTotal;
import org.anchoranalysis.mpp.feature.energy.scheme.DictionaryForImageCreator;
import org.anchoranalysis.mpp.feature.energy.scheme.EnergyScheme;
import org.anchoranalysis.mpp.feature.input.FeatureInputAllMemo;
import org.anchoranalysis.mpp.feature.input.FeatureInputSingleMemo;
import org.anchoranalysis.mpp.feature.mark.EnergyMemoList;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;

public class EnergySchemeWithSharedFeatures {
    private EnergyScheme energyScheme;
    private SharedFeatures sharedFeatures;
    private CalculateIndividualTotalOperation calculateTotalIndividual;
    private Logger logger;

    public EnergySchemeWithSharedFeatures(EnergyScheme energyScheme, SharedFeatures sharedFeatures, Logger logger) {
        this.energyScheme = energyScheme;
        this.sharedFeatures = sharedFeatures;
        this.logger = logger;
        this.calculateTotalIndividual = new CalculateIndividualTotalOperation();
    }

    public EnergyTotal totalAll(EnergyMemoList pxlMarkMemoList, EnergyStackWithoutParameters raster) throws NamedFeatureCalculateException {
        try {
            EnergyStack energyStack = this.createEnergyStack(raster);
            FeatureCalculatorMulti session = FeatureSession.with(this.energyScheme.getElemAllAsFeatureList(), (FeatureInitialization)new FeatureInitialization(energyStack.getParameters()), (SharedFeatures)this.sharedFeatures, (Logger)this.logger);
            FeatureInputAllMemo input = new FeatureInputAllMemo(pxlMarkMemoList, energyStack);
            return new EnergyTotal(session.calculate((FeatureInput)input).total());
        }
        catch (InitializeException | FeatureCalculationException e) {
            throw new NamedFeatureCalculateException((Exception)e);
        }
    }

    public EnergyTotal totalIndividual(VoxelizedMarkMemo pmm, EnergyStackWithoutParameters raster) throws NamedFeatureCalculateException {
        try {
            this.calculateTotalIndividual.update(pmm, raster);
            return this.calculateTotalIndividual.calc();
        }
        catch (OperationFailedException e) {
            throw new NamedFeatureCalculateException((Exception)((Object)e));
        }
    }

    public AddCriteriaEnergyPair createAddCriteria() throws CreateException {
        try {
            return new AddCriteriaEnergyPair(this.getEnergyScheme().getElemPairAsFeatureList(), (AddCriteriaPair)this.getEnergyScheme().getPairAddCriteria().duplicateBean());
        }
        catch (BeanDuplicateException | InitializeException e) {
            throw new CreateException(e);
        }
    }

    public RegionMap getRegionMap() {
        return this.energyScheme.getRegionMap();
    }

    private EnergyStack createEnergyStack(EnergyStackWithoutParameters raster) throws FeatureCalculationException {
        try {
            return new EnergyStack(raster, this.energyScheme.createDictionary());
        }
        catch (CreateException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    public EnergyScheme getEnergyScheme() {
        return this.energyScheme;
    }

    public SharedFeatures getSharedFeatures() {
        return this.sharedFeatures;
    }

    private class CalculateIndividualTotalOperation
    implements CheckedFunction<Integer, EnergyTotal, NamedFeatureCalculateException> {
        private VoxelizedMarkMemo mark;
        private EnergyStackWithoutParameters raster;
        private Dictionary dictionary;

        private CalculateIndividualTotalOperation() {
        }

        public void update(VoxelizedMarkMemo mark, EnergyStackWithoutParameters raster) throws OperationFailedException {
            this.mark = mark;
            this.raster = raster;
            DictionaryForImageCreator creator = new DictionaryForImageCreator(EnergySchemeWithSharedFeatures.this.energyScheme, EnergySchemeWithSharedFeatures.this.sharedFeatures, EnergySchemeWithSharedFeatures.this.logger);
            try {
                this.dictionary = creator.create(raster);
            }
            catch (CreateException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }

        public EnergyTotal apply(Integer index) throws NamedFeatureCalculateException {
            return this.calc();
        }

        public EnergyTotal calc() throws NamedFeatureCalculateException {
            try {
                FeatureCalculatorMulti session = FeatureSession.with(EnergySchemeWithSharedFeatures.this.energyScheme.getElemIndAsFeatureList(), (FeatureInitialization)new FeatureInitialization(this.dictionary), (SharedFeatures)EnergySchemeWithSharedFeatures.this.sharedFeatures, (Logger)EnergySchemeWithSharedFeatures.this.logger);
                FeatureInputSingleMemo input = new FeatureInputSingleMemo(this.mark, new EnergyStack(this.raster, this.dictionary));
                return new EnergyTotal(session.calculate((FeatureInput)input).total());
            }
            catch (InitializeException e) {
                throw new NamedFeatureCalculateException((Exception)((Object)e));
            }
        }
    }
}

