/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.bean.energy.scheme;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.bean.operator.Sum;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteriaPair;
import org.anchoranalysis.mpp.feature.bean.energy.scheme.EnergySchemeCreator;
import org.anchoranalysis.mpp.feature.energy.scheme.EnergyScheme;
import org.anchoranalysis.mpp.feature.input.FeatureInputAllMemo;
import org.anchoranalysis.mpp.feature.input.FeatureInputPairMemo;
import org.anchoranalysis.mpp.feature.input.FeatureInputSingleMemo;

public class EnergySchemeCreatorByElement
extends EnergySchemeCreator {
    @BeanField
    private FeatureListProvider<FeatureInputSingleMemo> elemIndCreator;
    @BeanField
    private FeatureListProvider<FeatureInputPairMemo> elemPairCreator;
    @BeanField
    @OptionalBean
    private FeatureListProvider<FeatureInputAllMemo> elemAllCreator;
    @BeanField
    private List<NamedBean<FeatureListProvider<FeatureInputStack>>> listImageFeatures = new ArrayList<NamedBean<FeatureListProvider<FeatureInputStack>>>();
    @BeanField
    private AddCriteriaPair pairAddCriteria;
    @BeanField
    private RegionMap regionMap;
    @BeanField
    @OptionalBean
    private DictionaryProvider dictionary;
    @BeanField
    private boolean includeFeatureNames = false;

    @Override
    public EnergyScheme create() throws CreateException {
        try {
            return new EnergyScheme((FeatureList<FeatureInputSingleMemo>)((FeatureList)this.elemIndCreator.get()), (FeatureList<FeatureInputPairMemo>)((FeatureList)this.elemPairCreator.get()), this.createAll(), this.regionMap, this.pairAddCriteria, Optional.ofNullable(this.dictionary), this.buildImageFeatures());
        }
        catch (ProvisionFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private FeatureList<FeatureInputAllMemo> createAll() throws CreateException {
        try {
            if (this.elemAllCreator != null) {
                return (FeatureList)this.elemAllCreator.get();
            }
            return FeatureListFactory.empty();
        }
        catch (ProvisionFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private List<NamedBean<Feature<FeatureInputStack>>> buildImageFeatures() throws CreateException {
        try {
            return FunctionalList.mapToList(this.listImageFeatures, ProvisionFailedException.class, ni -> this.sumList((FeatureList<FeatureInputStack>)((FeatureList)((FeatureListProvider)ni.getValue()).get()), ni.getName()));
        }
        catch (ProvisionFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private NamedBean<Feature<FeatureInputStack>> sumList(FeatureList<FeatureInputStack> fl, String name) {
        Sum feature = new Sum(fl);
        return new NamedBean(this.nameForFeature((Feature<?>)feature, name), (AnchorBean)feature);
    }

    private String nameForFeature(Feature<?> feature, String name) {
        if (this.includeFeatureNames) {
            return String.format("%s.%s", name, feature.getFriendlyName());
        }
        return name;
    }

    @Generated
    public FeatureListProvider<FeatureInputSingleMemo> getElemIndCreator() {
        return this.elemIndCreator;
    }

    @Generated
    public void setElemIndCreator(FeatureListProvider<FeatureInputSingleMemo> elemIndCreator) {
        this.elemIndCreator = elemIndCreator;
    }

    @Generated
    public FeatureListProvider<FeatureInputPairMemo> getElemPairCreator() {
        return this.elemPairCreator;
    }

    @Generated
    public void setElemPairCreator(FeatureListProvider<FeatureInputPairMemo> elemPairCreator) {
        this.elemPairCreator = elemPairCreator;
    }

    @Generated
    public FeatureListProvider<FeatureInputAllMemo> getElemAllCreator() {
        return this.elemAllCreator;
    }

    @Generated
    public void setElemAllCreator(FeatureListProvider<FeatureInputAllMemo> elemAllCreator) {
        this.elemAllCreator = elemAllCreator;
    }

    @Generated
    public List<NamedBean<FeatureListProvider<FeatureInputStack>>> getListImageFeatures() {
        return this.listImageFeatures;
    }

    @Generated
    public void setListImageFeatures(List<NamedBean<FeatureListProvider<FeatureInputStack>>> listImageFeatures) {
        this.listImageFeatures = listImageFeatures;
    }

    @Generated
    public AddCriteriaPair getPairAddCriteria() {
        return this.pairAddCriteria;
    }

    @Generated
    public void setPairAddCriteria(AddCriteriaPair pairAddCriteria) {
        this.pairAddCriteria = pairAddCriteria;
    }

    @Generated
    public RegionMap getRegionMap() {
        return this.regionMap;
    }

    @Generated
    public void setRegionMap(RegionMap regionMap) {
        this.regionMap = regionMap;
    }

    @Generated
    public DictionaryProvider getDictionary() {
        return this.dictionary;
    }

    @Generated
    public void setDictionary(DictionaryProvider dictionary) {
        this.dictionary = dictionary;
    }

    @Generated
    public boolean isIncludeFeatureNames() {
        return this.includeFeatureNames;
    }

    @Generated
    public void setIncludeFeatureNames(boolean includeFeatureNames) {
        this.includeFeatureNames = includeFeatureNames;
    }
}

