/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.bean.mark;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.input.FeatureInputDictionary;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.mpp.mark.Mark;

public class FeatureInputMark
implements FeatureInputDictionary {
    private final Mark mark;
    private final Optional<Dimensions> dimensions;
    private final Optional<Dictionary> dictionary;

    public FeatureInputMark(Mark mark, Optional<Dimensions> dimensions) {
        this(mark, dimensions, Optional.empty());
    }

    public FeatureInputMark(Mark mark, Dimensions dimensions, Dictionary dictionary) {
        this(mark, Optional.of(dimensions), Optional.of(dictionary));
    }

    public Optional<Resolution> getResolutionOptional() {
        return this.dimensions.flatMap(Dimensions::resolution);
    }

    public Optional<Dictionary> getDictionaryOptional() {
        return this.dictionary;
    }

    public Optional<Dimensions> getDimensionsOptional() {
        return this.dimensions;
    }

    public Dimensions getDimensionsRequired() throws FeatureCalculationException {
        return this.dimensions.orElseThrow(() -> new FeatureCalculationException("Dimensions are required in the input for this operation"));
    }

    @Generated
    public FeatureInputMark(Mark mark, Optional<Dimensions> dimensions, Optional<Dictionary> dictionary) {
        this.mark = mark;
        this.dimensions = dimensions;
        this.dictionary = dictionary;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureInputMark)) {
            return false;
        }
        FeatureInputMark other = (FeatureInputMark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Mark this$mark = this.getMark();
        Mark other$mark = other.getMark();
        if (this$mark == null ? other$mark != null : !this$mark.equals(other$mark)) {
            return false;
        }
        Optional<Dimensions> this$dimensions = this.dimensions;
        Optional<Dimensions> other$dimensions = other.dimensions;
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        Optional<Dictionary> this$dictionary = this.dictionary;
        Optional<Dictionary> other$dictionary = other.dictionary;
        return !(this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeatureInputMark;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Mark $mark = this.getMark();
        result = result * 59 + ($mark == null ? 43 : $mark.hashCode());
        Optional<Dimensions> $dimensions = this.dimensions;
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        Optional<Dictionary> $dictionary = this.dictionary;
        result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
        return result;
    }

    @Generated
    public Mark getMark() {
        return this.mark;
    }
}

