/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.energy.marks;

import java.io.Serializable;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.mpp.feature.energy.scheme.EnergySchemeWithSharedFeatures;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;

public class MarksWithTotalEnergy
implements Serializable {
    private static final long serialVersionUID = -7008599104878130986L;
    private MarkCollection marks;
    private transient EnergySchemeWithSharedFeatures energyScheme;
    private double energyTotal = 0.0;

    public MarksWithTotalEnergy(MarkCollection marks, EnergySchemeWithSharedFeatures energyScheme) {
        this.marks = marks;
        this.energyScheme = energyScheme;
        this.energyTotal = 0.0;
    }

    public MarksWithTotalEnergy shallowCopy() {
        return new MarksWithTotalEnergy(this.marks, this.energyScheme, this.energyTotal);
    }

    public MarksWithTotalEnergy deepCopy() {
        return new MarksWithTotalEnergy(this.marks.deepCopy(), this.energyScheme, this.energyTotal);
    }

    public void add(VoxelizedMarkMemo voxelizedMark) {
        this.replaceWithShallowCopy(marksCopy -> marksCopy.add(voxelizedMark.getMark()));
    }

    public void remove(int index) {
        this.replaceWithShallowCopy(marksCopy -> marksCopy.remove(index));
    }

    public void exchange(int index, VoxelizedMarkMemo newMark) {
        this.replaceWithShallowCopy(marksCopy -> marksCopy.exchange(index, newMark.getMark()));
    }

    public final int size() {
        return this.marks.size();
    }

    public Mark get(int index) {
        return this.marks.get(index);
    }

    private void replaceWithShallowCopy(Consumer<MarkCollection> operationAfterCopy) {
        MarkCollection marksCopy = this.marks.shallowCopy();
        operationAfterCopy.accept(marksCopy);
        this.marks = marksCopy;
    }

    @Generated
    private MarksWithTotalEnergy(MarkCollection marks, EnergySchemeWithSharedFeatures energyScheme, double energyTotal) {
        this.marks = marks;
        this.energyScheme = energyScheme;
        this.energyTotal = energyTotal;
    }

    @Generated
    public MarkCollection getMarks() {
        return this.marks;
    }

    @Generated
    public void setMarks(MarkCollection marks) {
        this.marks = marks;
    }

    @Generated
    public EnergySchemeWithSharedFeatures getEnergyScheme() {
        return this.energyScheme;
    }

    @Generated
    public double getEnergyTotal() {
        return this.energyTotal;
    }

    @Generated
    public void setEnergyTotal(double energyTotal) {
        this.energyTotal = energyTotal;
    }
}

