/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.energy.saved;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import lombok.Generated;
import org.anchoranalysis.mpp.feature.energy.EnergyTotal;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;

public class EnergySavedIndividual
implements Serializable,
Iterable<EnergyTotal> {
    private static final long serialVersionUID = -5205697546115728135L;
    private double energyTotal;
    private ArrayList<EnergyTotal> ind;

    public EnergySavedIndividual shallowCopy() {
        EnergySavedIndividual out = new EnergySavedIndividual();
        out.ind = new ArrayList();
        this.ind.stream().forEach(out.ind::add);
        out.energyTotal = this.energyTotal;
        return out;
    }

    public EnergySavedIndividual deepCopy() {
        EnergySavedIndividual out = new EnergySavedIndividual();
        out.ind = new ArrayList();
        this.ind.forEach((? super E indComponent) -> out.ind.add(indComponent.deepCopy()));
        out.energyTotal = this.energyTotal;
        return out;
    }

    public int size() {
        return this.ind.size();
    }

    public EnergyTotal get(int index) {
        return this.ind.get(index);
    }

    public void resetInd() {
        this.ind = new ArrayList();
    }

    public void add(EnergyTotal item) {
        this.ind.add(item);
        this.energyTotal += item.getTotal();
    }

    public void rmv(int index) {
        this.energyTotal -= this.ind.get(index).getTotal();
        this.ind.remove(index);
    }

    public void exchange(int index, EnergyTotal item) {
        this.energyTotal -= this.get(index).getTotal();
        this.energyTotal += item.getTotal();
        this.ind.set(index, item);
    }

    public String describeMarks(MarkCollection marks) {
        String newLine = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder("{");
        s.append(newLine);
        int i = 0;
        Iterator<EnergyTotal> iteratorEnergy = this.ind.iterator();
        Iterator iteratorMark = marks.iterator();
        while (iteratorMark.hasNext()) {
            assert (iteratorEnergy.hasNext());
            s.append(String.format("%d. %s    energy=%e%n", i++, ((Mark)iteratorMark.next()).toString(), iteratorEnergy.next().getTotal()));
        }
        s.append("}");
        s.append(newLine);
        return s.toString();
    }

    public void assertValid() {
        assert (!Double.isNaN(this.energyTotal));
    }

    @Override
    public Iterator<EnergyTotal> iterator() {
        return this.ind.iterator();
    }

    @Generated
    public double getEnergyTotal() {
        return this.energyTotal;
    }

    @Generated
    public void setEnergyTotal(double energyTotal) {
        this.energyTotal = energyTotal;
    }
}

