/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.energy.saved;

import java.util.Set;
import lombok.Generated;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.graph.TypedEdge;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteria;
import org.anchoranalysis.mpp.feature.addcriteria.RandomCollectionWithAddCriteria;
import org.anchoranalysis.mpp.feature.energy.EnergyPair;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.mpp.mark.UpdatableMarks;
import org.anchoranalysis.mpp.mark.UpdateMarkSetException;
import org.anchoranalysis.mpp.mark.voxelized.memo.MemoForIndex;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;

public class EnergySavedPairs
implements UpdatableMarks {
    private double energyTotal;
    private RandomCollectionWithAddCriteria<EnergyPair> pairCollection = new RandomCollectionWithAddCriteria(EnergyPair.class);

    public EnergySavedPairs(AddCriteria<EnergyPair> addCriteria) {
        this.pairCollection.setAddCriteria(addCriteria);
    }

    public EnergySavedPairs shallowCopy() {
        EnergySavedPairs out = new EnergySavedPairs(this.pairCollection.getAddCriteria());
        out.pairCollection = this.pairCollection.shallowCopy();
        out.energyTotal = this.energyTotal;
        return out;
    }

    public EnergySavedPairs deepCopy() {
        EnergySavedPairs out = new EnergySavedPairs(this.pairCollection.getAddCriteria());
        out.pairCollection = this.pairCollection.deepCopy();
        out.energyTotal = this.energyTotal;
        return out;
    }

    public void initUpdatableMarks(MemoForIndex pxlMarkMemoList, EnergyStack stack, Logger logger, SharedFeatures sharedFeatures) throws InitializeException {
        this.pairCollection.initUpdatableMarks(pxlMarkMemoList, stack, logger, sharedFeatures);
        this.calculateTotalFresh();
    }

    private void calculateTotalFresh() {
        this.energyTotal = 0.0;
        for (EnergyPair pair : this.pairCollection.createPairsUnique()) {
            this.energyTotal += pair.getEnergyTotal().getTotal();
        }
        assert (!Double.isNaN(this.energyTotal));
    }

    private double totalEnergyForMark(Mark mark) {
        double total = 0.0;
        for (TypedEdge<Mark, EnergyPair> pair : this.pairCollection.getPairsFor(mark)) {
            total += ((EnergyPair)pair.getPayload()).getEnergyTotal().getTotal();
        }
        assert (!Double.isNaN(total));
        return total;
    }

    public void add(MemoForIndex pxlMarkMemoList, VoxelizedMarkMemo newMark) throws UpdateMarkSetException {
        this.pairCollection.add(pxlMarkMemoList, newMark);
        this.energyTotal += this.totalEnergyForMark(newMark.getMark());
        assert (!Double.isNaN(this.energyTotal));
    }

    public void remove(MemoForIndex marksExisting, VoxelizedMarkMemo mark) throws UpdateMarkSetException {
        this.energyTotal -= this.totalEnergyForMark(mark.getMark());
        this.pairCollection.remove(marksExisting, mark);
        assert (!Double.isNaN(this.energyTotal));
    }

    public void exchange(MemoForIndex memo, VoxelizedMarkMemo oldMark, int indexOldMark, VoxelizedMarkMemo newMark) throws UpdateMarkSetException {
        double oldPairTotal = this.totalEnergyForMark(oldMark.getMark());
        this.pairCollection.exchange(memo, oldMark, indexOldMark, newMark);
        double newPairTotal = this.totalEnergyForMark(newMark.getMark());
        this.energyTotal = this.energyTotal - oldPairTotal + newPairTotal;
    }

    public boolean isMarksSpan(MarkCollection marks) {
        return this.pairCollection.isMarksSpan(marks);
    }

    public String toString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder("{");
        s.append(newLine);
        for (EnergyPair di : this.createPairsUnique()) {
            s.append(String.format("%2d--%2d\tenergy=%e%n", di.getPair().getSource().getIdentifier(), di.getPair().getDestination().getIdentifier(), di.getEnergyTotal().getTotal()));
        }
        s.append("}" + newLine);
        return s.toString();
    }

    public void assertValid() {
        assert (!Double.isNaN(this.energyTotal));
    }

    public Set<EnergyPair> createPairsUnique() {
        return this.pairCollection.createPairsUnique();
    }

    @Generated
    public double getEnergyTotal() {
        return this.energyTotal;
    }
}

