/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.energy.scheme;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.mpp.feature.energy.scheme.EnergyScheme;

public class DictionaryForImageCreator {
    private EnergyScheme energyScheme;
    private SharedFeatures sharedFeatures;
    private Logger logger;

    public Dictionary create(EnergyStackWithoutParameters energyStack) throws CreateException {
        try {
            Dictionary dictionary = this.energyScheme.createDictionary();
            this.addParametersForImage(energyStack, dictionary);
            return dictionary;
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private void addParametersForImage(EnergyStackWithoutParameters energyStack, Dictionary dictionary) throws OperationFailedException {
        FeatureInputStack parameters = new FeatureInputStack(energyStack);
        FeatureInitialization initialization = new FeatureInitialization(Optional.of(dictionary), Optional.of(energyStack), Optional.empty());
        for (NamedBean<Feature<FeatureInputStack>> feature : this.energyScheme.getListImageFeatures()) {
            dictionary.putCheck(feature.getName(), this.calculateImageFeature((Feature<FeatureInputStack>)((Feature)feature.getItem()), initialization, parameters));
        }
    }

    private double calculateImageFeature(Feature<FeatureInputStack> feature, FeatureInitialization initialization, FeatureInputStack parameters) throws OperationFailedException {
        try {
            FeatureCalculatorSingle session = FeatureSession.with(feature, (FeatureInitialization)initialization, (SharedFeatures)this.sharedFeatures, (Logger)this.logger);
            return session.calculate((FeatureInput)parameters);
        }
        catch (InitializeException | FeatureCalculationException e) {
            throw new OperationFailedException(e);
        }
    }

    @Generated
    public DictionaryForImageCreator(EnergyScheme energyScheme, SharedFeatures sharedFeatures, Logger logger) {
        this.energyScheme = energyScheme;
        this.sharedFeatures = sharedFeatures;
        this.logger = logger;
    }
}

