/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.energy.scheme;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.feature.addcriteria.AddCriteriaPair;
import org.anchoranalysis.mpp.feature.input.FeatureInputAllMemo;
import org.anchoranalysis.mpp.feature.input.FeatureInputPairMemo;
import org.anchoranalysis.mpp.feature.input.FeatureInputSingleMemo;

public class EnergyScheme {
    private final FeatureList<FeatureInputSingleMemo> individual;
    private final FeatureList<FeatureInputPairMemo> pair;
    private final FeatureList<FeatureInputAllMemo> all;
    private final RegionMap regionMap;
    private final List<NamedBean<Feature<FeatureInputStack>>> listImageFeatures;
    private final AddCriteriaPair pairAddCriteria;
    private final Optional<DictionaryProvider> dictionary;

    public EnergyScheme(FeatureList<FeatureInputSingleMemo> individual, FeatureList<FeatureInputPairMemo> pair, FeatureList<FeatureInputAllMemo> all, RegionMap regionMap, AddCriteriaPair pairAddCriteria) throws CreateException {
        this(individual, pair, all, regionMap, pairAddCriteria, Optional.empty(), new ArrayList<NamedBean<Feature<FeatureInputStack>>>());
    }

    public EnergyScheme(FeatureList<FeatureInputSingleMemo> individual, FeatureList<FeatureInputPairMemo> pair, FeatureList<FeatureInputAllMemo> all, RegionMap regionMap, AddCriteriaPair pairAddCriteria, Optional<DictionaryProvider> dictionary, List<NamedBean<Feature<FeatureInputStack>>> listImageFeatures) throws CreateException {
        this.individual = individual;
        this.pair = pair;
        this.all = all;
        this.regionMap = regionMap;
        this.pairAddCriteria = pairAddCriteria;
        this.dictionary = dictionary;
        this.listImageFeatures = listImageFeatures;
        this.checkAtLeastOneEnergyElement();
    }

    public Dictionary createDictionary() throws CreateException {
        if (this.dictionary.isPresent()) {
            try {
                return ((Dictionary)this.dictionary.get().get()).duplicate();
            }
            catch (ProvisionFailedException e) {
                throw new CreateException((Throwable)e);
            }
        }
        return new Dictionary();
    }

    public <T extends FeatureInput> FeatureList<T> getElemByCliqueSize(int cliqueSize) {
        return switch (cliqueSize) {
            case 0 -> this.individual;
            case 1 -> this.pair;
            case -1 -> this.all;
            default -> throw new AnchorImpossibleSituationException();
        };
    }

    private void checkAtLeastOneEnergyElement() throws CreateException {
        if (this.individual.size() + this.pair.size() + this.all.size() == 0) {
            throw new CreateException("At least one Energy element must be specified");
        }
    }

    @Generated
    public FeatureList<FeatureInputSingleMemo> getIndividual() {
        return this.individual;
    }

    @Generated
    public FeatureList<FeatureInputPairMemo> getPair() {
        return this.pair;
    }

    @Generated
    public FeatureList<FeatureInputAllMemo> getAll() {
        return this.all;
    }

    @Generated
    public RegionMap getRegionMap() {
        return this.regionMap;
    }

    @Generated
    public List<NamedBean<Feature<FeatureInputStack>>> getListImageFeatures() {
        return this.listImageFeatures;
    }

    @Generated
    public AddCriteriaPair getPairAddCriteria() {
        return this.pairAddCriteria;
    }
}

