/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.feature.mark;

import java.io.Serializable;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.mpp.bean.regionmap.RegionMap;
import org.anchoranalysis.mpp.feature.energy.EnergyTotal;
import org.anchoranalysis.mpp.feature.energy.saved.EnergySavedIndividual;
import org.anchoranalysis.mpp.feature.energy.scheme.EnergySchemeWithSharedFeatures;
import org.anchoranalysis.mpp.feature.mark.MemoList;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.mpp.mark.voxelized.memo.MemoForIndex;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemoFactory;

public class EnergyMemoList
implements Serializable,
MemoForIndex {
    private static final long serialVersionUID = 9067220044867268357L;
    private transient MemoList list;
    private transient RegionMap regionMap;

    public EnergyMemoList() {
        this.list = new MemoList();
    }

    public EnergyMemoList(EnergySavedIndividual savedInd, EnergyStackWithoutParameters energyStack, MarkCollection marks, EnergySchemeWithSharedFeatures energySchemeTotal) throws NamedFeatureCalculateException {
        this.regionMap = energySchemeTotal.getRegionMap();
        this.calculateFreshInd(savedInd, energyStack, marks, energySchemeTotal);
    }

    public EnergyMemoList(EnergyMemoList source) {
        this.list = new MemoList();
        this.regionMap = source.getRegionMap();
        for (VoxelizedMarkMemo pmm : source.list) {
            this.list.add(pmm);
        }
    }

    public void clean() {
        this.list = null;
    }

    public int size() {
        return this.list.size();
    }

    public RegionMap getRegionMap() {
        return this.regionMap;
    }

    public VoxelizedMarkMemo getMemoForMark(MarkCollection marks, Mark mark) {
        int index = marks.indexOf(mark);
        if (index == -1) {
            throw new AnchorFriendlyRuntimeException("Mark doesn't exist in marks");
        }
        return this.list.get(index);
    }

    public VoxelizedMarkMemo getMemoForIndex(int index) {
        return this.list.get(index);
    }

    public int getIndexForMemo(VoxelizedMarkMemo memo) {
        for (int i = 0; i < this.list.size(); ++i) {
            VoxelizedMarkMemo pmm = this.list.get(i);
            if (!pmm.equals(memo)) continue;
            return i;
        }
        return -1;
    }

    private void calculateFreshInd(EnergySavedIndividual energySavedInd, EnergyStackWithoutParameters energyStack, MarkCollection marks, EnergySchemeWithSharedFeatures energySchemeTotal) throws NamedFeatureCalculateException {
        energySavedInd.setEnergyTotal(0.0);
        this.list = new MemoList();
        energySavedInd.resetInd();
        for (Mark mrk : marks) {
            VoxelizedMarkMemo pmm = VoxelizedMarkMemoFactory.create((Mark)mrk, (EnergyStackWithoutParameters)energyStack, (RegionMap)energySchemeTotal.getRegionMap());
            this.list.add(pmm);
            EnergyTotal ind = energySchemeTotal.totalIndividual(pmm, energyStack);
            energySavedInd.add(ind);
        }
    }

    public VoxelizedMarkMemo exchange(EnergySavedIndividual energySavedInd, int index, VoxelizedMarkMemo newMark, EnergyStackWithoutParameters stack, EnergySchemeWithSharedFeatures energySchemeTotal) throws NamedFeatureCalculateException {
        EnergyTotal ind = energySchemeTotal.totalIndividual(newMark, stack);
        energySavedInd.exchange(index, ind);
        this.list.set(index, newMark);
        return newMark;
    }

    public VoxelizedMarkMemo add(EnergySavedIndividual energySavedInd, VoxelizedMarkMemo memo, EnergyStackWithoutParameters stack, EnergySchemeWithSharedFeatures energyScheme) throws NamedFeatureCalculateException {
        EnergyTotal energy = energyScheme.totalIndividual(memo, stack);
        this.list.add(memo);
        energySavedInd.add(energy);
        return memo;
    }

    public void remove(EnergySavedIndividual energySavedInd, int index) {
        energySavedInd.rmv(index);
        this.list.remove(index);
    }

    public void removeTwo(EnergySavedIndividual energySavedInd, int index1, int index2) {
        int indexMax = Math.max(index1, index2);
        int indexMin = Math.min(index1, index2);
        this.remove(energySavedInd, indexMax);
        this.remove(energySavedInd, indexMin);
    }

    public MarkCollection asMarks() {
        MarkCollection marks = new MarkCollection();
        for (int i = 0; i < this.size(); ++i) {
            VoxelizedMarkMemo pmm = this.getMemoForIndex(i);
            marks.add(pmm.getMark());
        }
        return marks;
    }
}

