/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.bean.bound;

import java.util.Optional;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.mpp.bean.bound.Bound;
import org.anchoranalysis.mpp.bean.bound.BoundMinMax;

public class BoundDegrees
extends BoundMinMax {
    private static final long serialVersionUID = 1281361242890359356L;

    public BoundDegrees() {
        super(0.0, 360.0);
    }

    public BoundDegrees(BoundDegrees source) {
        super(source);
    }

    @Override
    public double getMinResolved(Optional<Resolution> resolution, boolean do3D) {
        return BoundDegrees.convertDegreesToRadians(this.getMin());
    }

    @Override
    public double getMaxResolved(Optional<Resolution> resolution, boolean do3D) {
        return BoundDegrees.convertDegreesToRadians(this.getMax());
    }

    @Override
    public Bound duplicate() {
        return new BoundDegrees(this);
    }

    private static double convertDegreesToRadians(double degrees) {
        return Math.PI / 180 * degrees;
    }
}

