/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.bean.bound.rotation;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.random.RandomNumberGenerator;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.mpp.bean.bound.Bound;
import org.anchoranalysis.mpp.bean.bound.BoundUnitless;
import org.anchoranalysis.mpp.bean.bound.rotation.BoundRotation;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.Orientation3DEulerAngles;

public class BoundRotation3D
extends BoundRotation {
    private static final Bound DEFAULT_BOUND = new BoundUnitless(0.0, Math.PI * 2);
    @BeanField
    private Bound rotationX = DEFAULT_BOUND;
    @BeanField
    private Bound rotationY = DEFAULT_BOUND;
    @BeanField
    private Bound rotationZ = DEFAULT_BOUND;

    @Override
    public Orientation randomOrientation(RandomNumberGenerator randomNumberGenerator, Optional<Resolution> resolution) {
        return new Orientation3DEulerAngles(BoundRotation3D.randomizeRotation(this.rotationX, randomNumberGenerator, resolution), BoundRotation3D.randomizeRotation(this.rotationY, randomNumberGenerator, resolution), BoundRotation3D.randomizeRotation(this.rotationZ, randomNumberGenerator, resolution));
    }

    public String describeBean() {
        return String.format("%s, rotation=(%f,%f,%f)", this.getBeanName(), this.getRotationX(), this.getRotationY(), this.rotationZ);
    }

    private static double randomizeRotation(Bound bound, RandomNumberGenerator randomNumberGenerator, Optional<Resolution> resolution) {
        return bound.resolve(resolution, true).randOpen(randomNumberGenerator);
    }

    public Bound getRotationX() {
        return this.rotationX;
    }

    public void setRotationX(Bound rotationX) {
        this.rotationX = rotationX;
    }

    public Bound getRotationY() {
        return this.rotationY;
    }

    public void setRotationY(Bound rotationY) {
        this.rotationY = rotationY;
    }

    public Bound getRotationZ() {
        return this.rotationZ;
    }

    public void setRotationZ(Bound rotationZ) {
        this.rotationZ = rotationZ;
    }
}

