/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.bean.mark.factory;

import org.anchoranalysis.bean.NullParametersBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.mpp.bean.mark.factory.IdCounter;
import org.anchoranalysis.mpp.bean.mark.factory.MarkFactory;
import org.anchoranalysis.mpp.mark.Mark;

public class MarkWithIdentifierFactory
extends NullParametersBean<MarkWithIdentifierFactory> {
    @BeanField
    private double referencePoissonIntensity = 1.0E-5;
    @BeanField
    private MarkFactory templateMark = null;
    private IdCounter idCounter;

    public MarkWithIdentifierFactory(MarkFactory templateMark) {
        this.templateMark = templateMark;
    }

    public String describeBean() {
        return String.format("%s templateMark=%s, referencePoissonIntensity=%f", this.getBeanName(), this.templateMark.toString(), this.referencePoissonIntensity);
    }

    public void onInitialization() throws InitializeException {
        super.onInitialization();
        this.idCounter = new IdCounter(1);
    }

    public Mark newTemplateMark() {
        assert (this.templateMark != null);
        Mark mark = this.templateMark.create();
        mark.setId(this.idAndIncrement());
        return mark;
    }

    public int idAndIncrement() {
        assert (this.idCounter != null);
        return this.idCounter.getIdAndIncrement();
    }

    public MarkWithIdentifierFactory() {
    }

    public double getReferencePoissonIntensity() {
        return this.referencePoissonIntensity;
    }

    public void setReferencePoissonIntensity(double referencePoissonIntensity) {
        this.referencePoissonIntensity = referencePoissonIntensity;
    }

    public MarkFactory getTemplateMark() {
        return this.templateMark;
    }

    public void setTemplateMark(MarkFactory templateMark) {
        this.templateMark = templateMark;
    }
}

