/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.bean.points;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.SkipInit;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitter;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.bean.provider.SingleMarkProvider;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.mpp.mark.points.PointList;
import org.anchoranalysis.spatial.point.Point3f;
import org.anchoranalysis.spatial.point.PointConverter;

public class CreateMarkFromPoints
extends AnchorBean<CreateMarkFromPoints> {
    @BeanField
    @SkipInit
    private SingleMarkProvider markProvider;
    @BeanField
    @SkipInit
    private PointsFitter pointsFitter;
    @BeanField
    private int minNumPoints = 20;
    @BeanField
    private boolean throwExceptionForInsufficientPoints = false;

    public Optional<Mark> fitMarkToPointsFromMarks(MarkCollection marks, Dimensions dimensions) throws OperationFailedException {
        try {
            Mark mark = (Mark)((Optional)this.markProvider.get()).orElseThrow(() -> new OperationFailedException("A mark is required for this operation"));
            List<Point3f> points = CreateMarkFromPoints.extractPointsFromMarks(marks);
            if (points.size() >= this.minNumPoints) {
                return this.fitPoints(mark, points, dimensions);
            }
            return this.maybeThrowInsufficientPointsException(points);
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private Optional<Mark> fitPoints(Mark mark, List<Point3f> points, Dimensions dimensions) throws OperationFailedException {
        try {
            this.pointsFitter.fit(points, mark, dimensions);
            return Optional.of(mark);
        }
        catch (InsufficientPointsException e) {
            return this.maybeThrowInsufficientPointsException(points);
        }
        catch (PointsFitterException e) {
            throw new OperationFailedException((Throwable)((Object)e));
        }
    }

    private Optional<Mark> maybeThrowInsufficientPointsException(List<Point3f> points) throws OperationFailedException {
        if (this.throwExceptionForInsufficientPoints) {
            throw new OperationFailedException(String.format("There are an insufficient number of points to successfully create a mark (number_pts=%d, min_number=%d)", points.size(), this.minNumPoints));
        }
        return Optional.empty();
    }

    private static List<Point3f> extractPointsFromMarks(MarkCollection marks) throws OperationFailedException {
        ArrayList<Point3f> out = new ArrayList<Point3f>();
        for (Mark m : marks) {
            if (m instanceof PointList) {
                CreateMarkFromPoints.addPointsFrom((PointList)m, out);
                continue;
            }
            throw new OperationFailedException(String.format("At least one Mark in the marks is not a PointList, rather a %s", m.getClass()));
        }
        return out;
    }

    private static void addPointsFrom(PointList mark, List<Point3f> points) {
        points.addAll(PointConverter.convert3dTo3f(mark.getPoints()));
    }

    public SingleMarkProvider getMarkProvider() {
        return this.markProvider;
    }

    public void setMarkProvider(SingleMarkProvider markProvider) {
        this.markProvider = markProvider;
    }

    public PointsFitter getPointsFitter() {
        return this.pointsFitter;
    }

    public void setPointsFitter(PointsFitter pointsFitter) {
        this.pointsFitter = pointsFitter;
    }

    public int getMinNumPoints() {
        return this.minNumPoints;
    }

    public void setMinNumPoints(int minNumPoints) {
        this.minNumPoints = minNumPoints;
    }

    public boolean isThrowExceptionForInsufficientPoints() {
        return this.throwExceptionForInsufficientPoints;
    }

    public void setThrowExceptionForInsufficientPoints(boolean throwExceptionForInsufficientPoints) {
        this.throwExceptionForInsufficientPoints = throwExceptionForInsufficientPoints;
    }
}

