/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.color.ColorList;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.core.identifier.getter.IdentifierGetter;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.spatial.box.BoundingBox;

public class ColoredMarks
implements Iterable<Mark> {
    private MarkCollection marks;
    private ColorList colorList;

    public ColoredMarks() {
        this(new MarkCollection(), new ColorList());
    }

    public ColoredMarks(MarkCollection marks, ColorIndex colorIndex, IdentifierGetter<Mark> colorIDGetter) {
        this.marks = marks;
        this.colorList = new ColorList();
        for (int index = 0; index < marks.size(); ++index) {
            int colorID = colorIDGetter.getIdentifier((Object)marks.get(index), index);
            this.colorList.add(colorIndex.get(colorID));
        }
    }

    public ColoredMarks(Mark mark, RGBColor color) {
        this.marks = new MarkCollection(mark);
        this.colorList = new ColorList(new RGBColor[]{color});
    }

    public void add(Mark mark, Color color) {
        this.add(mark, new RGBColor(color));
    }

    public void addChangeID(Mark mark, Color color) {
        this.addChangeID(mark, new RGBColor(color));
    }

    public void addChangeID(Mark mark, RGBColor color) {
        this.marks.add(mark);
        this.colorList.add(color);
        mark.setId(this.colorList.size() - 1);
    }

    public void add(Mark mark, RGBColor color) {
        this.marks.add(mark);
        this.colorList.add(color);
    }

    public void addAll(MarkCollection marks, RGBColor color) {
        for (Mark mark : marks) {
            this.add(mark, color);
        }
    }

    public void addAll(ColoredMarks marks) {
        for (int i = 0; i < marks.size(); ++i) {
            this.add(marks.getMarks().get(i), marks.colorList.get(i));
        }
    }

    @Override
    public Iterator<Mark> iterator() {
        return this.marks.iterator();
    }

    public final int size() {
        return this.marks.size();
    }

    public ColoredMarks deepCopy() {
        ColoredMarks out = new ColoredMarks();
        out.marks = this.marks.deepCopy();
        out.colorList = this.colorList.deepCopy();
        return out;
    }

    public ColoredMarks shallowCopy() {
        ColoredMarks out = new ColoredMarks();
        out.marks = this.marks.shallowCopy();
        out.colorList = this.colorList.shallowCopy();
        return out;
    }

    public ColoredMarks createMerged(ColoredMarks toMerge) {
        ColoredMarks mergedNew = this.shallowCopy();
        Set<Mark> set = mergedNew.getMarks().createSet();
        for (int i = 0; i < toMerge.size(); ++i) {
            Mark m = toMerge.getMarks().get(i);
            if (set.contains(m)) continue;
            mergedNew.getMarks().add(m);
            mergedNew.getColorList().add(toMerge.getColorList().get(i));
        }
        return mergedNew;
    }

    public ColoredMarks subsetWhereBBoxIntersects(Dimensions dimensions, int regionID, List<BoundingBox> intersectList) {
        ColoredMarks intersectingMarks = new ColoredMarks();
        for (int i = 0; i < this.getMarks().size(); ++i) {
            Mark mark = this.getMarks().get(i);
            if (!mark.box(dimensions, regionID).intersection().existsWithAny(intersectList)) continue;
            intersectingMarks.add(mark.duplicate(), this.getColorList().get(i));
        }
        return intersectingMarks;
    }

    public void remove(int index) {
        this.colorList.remove(index);
        this.marks.remove(index);
    }

    public ColoredMarks(MarkCollection marks, ColorList colorList) {
        this.marks = marks;
        this.colorList = colorList;
    }

    public MarkCollection getMarks() {
        return this.marks;
    }

    public ColorList getColorList() {
        return this.colorList;
    }
}

