/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark;

import java.io.Serializable;
import java.util.Optional;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipWithFlags;
import org.anchoranalysis.mpp.mark.QuickOverlapCalculation;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public abstract class Mark
implements Serializable {
    private static final long serialVersionUID = 3272456193681334471L;
    private int id = -1;

    protected Mark(Mark source) {
        this.id = source.id;
    }

    public abstract byte isPointInside(Point3i var1);

    public abstract Mark duplicate();

    public abstract int numberRegions();

    public abstract String getName();

    public Optional<QuickOverlapCalculation> quickOverlap() {
        return Optional.empty();
    }

    public abstract double volume(int var1);

    public abstract void scale(ScaleFactor var1) throws CheckedUnsupportedOperationException;

    public abstract int numberDimensions();

    public abstract Point3d centerPoint();

    public abstract BoundingBox box(Dimensions var1, int var2);

    public abstract BoundingBox boxAllRegions(Dimensions var1);

    public boolean equalsID(Object obj) {
        if (obj instanceof Mark) {
            Mark mark = (Mark)obj;
            return this.id == mark.id;
        }
        return false;
    }

    public boolean equalsDeep(Mark mark) {
        return this.equalsID(mark);
    }

    public ObjectMask deriveObject(Dimensions dimensions, RegionMembershipWithFlags region, BinaryValuesByte binaryValues) {
        BoundingBox box = this.box(dimensions, region.getRegionID());
        ObjectMask object = new ObjectMask(box);
        byte maskOn = binaryValues.getOn();
        ReadableTuple3i maxPos = box.calculateCornerMaxInclusive();
        Point3i point = new Point3i();
        point.setZ(box.cornerMin().z());
        while (point.z() <= maxPos.z()) {
            int zLocal = point.z() - box.cornerMin().z();
            UnsignedByteBuffer maskSlice = object.sliceBufferLocal(zLocal);
            int count = 0;
            point.setY(box.cornerMin().y());
            while (point.y() <= maxPos.y()) {
                point.setX(box.cornerMin().x());
                while (point.x() <= maxPos.x()) {
                    byte membership = this.isPointInside(point);
                    if (region.isMemberFlag(membership)) {
                        maskSlice.putRaw(count, maskOn);
                    }
                    ++count;
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
        return object;
    }

    public String identifier() {
        return String.format("id=%10d", this.id);
    }

    public int getIdentifier() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Mark() {
    }
}

