/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark;

import java.util.Optional;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.regionmap.RegionMapSingleton;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipWithFlags;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class MarkToObjectConverter {
    private static final RegionMembershipWithFlags DEFAULT_REGION_MEMBERSHIP = RegionMapSingleton.instance().membershipWithFlagsForIndex(0);
    private final Optional<ScaleFactor> scaleFactor;
    private final Dimensions dimensions;
    private final RegionMembershipWithFlags regionMembership;
    private final BinaryValuesByte binaryValuesOut;

    public MarkToObjectConverter(Dimensions dimensions) {
        this(Optional.empty(), dimensions, DEFAULT_REGION_MEMBERSHIP, BinaryValuesByte.getDefault());
    }

    public MarkToObjectConverter(Optional<ScaleFactor> scaleFactor, Dimensions dimensions) {
        this(scaleFactor, dimensions, DEFAULT_REGION_MEMBERSHIP, BinaryValuesByte.getDefault());
    }

    public ObjectMask convert(Mark mark) {
        try {
            if (this.scaleFactor.isPresent() && !this.scaleFactor.get().isNoScale()) {
                mark.scale(this.scaleFactor.get());
            }
        }
        catch (CheckedUnsupportedOperationException e) {
            throw new AnchorImpossibleSituationException();
        }
        return mark.deriveObject(this.dimensions, this.regionMembership, this.binaryValuesOut);
    }

    public MarkToObjectConverter(Optional<ScaleFactor> scaleFactor, Dimensions dimensions, RegionMembershipWithFlags regionMembership, BinaryValuesByte binaryValuesOut) {
        this.scaleFactor = scaleFactor;
        this.dimensions = dimensions;
        this.regionMembership = regionMembership;
        this.binaryValuesOut = binaryValuesOut;
    }
}

