/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark;

import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class PointClamper {
    public static Point3i clamp(Point3i point, Dimensions dimensions) {
        point = PointClamper.clampLow(point);
        point = PointClamper.clampHigh(point, dimensions);
        return point;
    }

    public static Point3d clamp(Point3d point, Dimensions dimensions) {
        point = PointClamper.clampLow(point);
        point = PointClamper.clampHigh(point, dimensions);
        return point;
    }

    private static Point3i clampLow(Point3i point) {
        return point.max(0);
    }

    private static Point3d clampLow(Point3d point) {
        return point.max(0.0);
    }

    private static Point3i clampHigh(Point3i point, Dimensions dimensions) {
        return point.min((ReadableTuple3i)dimensions.extent().createMinusOne());
    }

    private static Point3d clampHigh(Point3d point, Dimensions dimensions) {
        return point.min((ReadableTuple3i)dimensions.extent().createMinusOne());
    }

    private PointClamper() {
    }
}

