/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.conic;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.QuickOverlapCalculation;
import org.anchoranalysis.mpp.mark.conic.BoundingBoxCalculator;
import org.anchoranalysis.mpp.mark.conic.ConicBase;
import org.anchoranalysis.mpp.mark.conic.EllipsoidMatrixCalculator;
import org.anchoranalysis.mpp.mark.conic.ScaleChecker;
import org.anchoranalysis.mpp.mark.conic.TensorUtilities;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.Orientation2D;
import org.anchoranalysis.spatial.point.Point2d;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class Ellipse
extends ConicBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NUMBER_DIMENSIONS = 2;
    private static final byte FLAG_SUBMARK_NONE = RegionMembershipUtilities.flagForNoRegion();
    private static final byte FLAG_SUBMARK_REGION0 = RegionMembershipUtilities.flagForRegion(0, 2);
    private static final byte FLAG_SUBMARK_REGION1 = RegionMembershipUtilities.flagForRegion(0, 1);
    private static final byte FLAG_SUBMARK_REGION2 = RegionMembershipUtilities.flagForRegion(1, 5);
    private static final byte FLAG_SUBMARK_REGION3 = RegionMembershipUtilities.flagForRegion(3);
    private transient QuickOverlapCalculation quickOverlap = (mark, regionID) -> {
        if (!(mark instanceof Ellipse)) {
            return false;
        }
        Ellipse targetMark = (Ellipse)mark;
        DoubleMatrix1D relativePosition = TensorUtilities.twoElementMatrix(targetMark.getPosition().x() - this.getPosition().x(), targetMark.getPosition().y() - this.getPosition().y());
        DoubleMatrix1D relativePositionSquared = relativePosition.copy();
        relativePositionSquared.assign(Functions.square);
        double distance = relativePositionSquared.zSum();
        return distance > Math.pow(this.getMaximumRadius() + targetMark.getMaximumRadius(), 2.0);
    };
    private double shell = 0.2;
    private Point2d radii;
    private Orientation orientation = new Orientation2D();
    private EllipsoidMatrixCalculator ellipsoidCalculator;
    private double shellInternal;
    private double shellExternal;
    private double shellExternalOut;
    private double shellInternalSquared;
    private double shellExternalSquared;
    private double shellExternalOutSquared;
    private double radiiShellMaxSquared;

    public Ellipse() {
        this.radii = new Point2d();
        this.ellipsoidCalculator = new EllipsoidMatrixCalculator(2);
    }

    public Ellipse(Ellipse source) {
        super(source);
        this.radii = new Point2d(source.radii);
        this.shell = source.shell;
        this.ellipsoidCalculator = new EllipsoidMatrixCalculator(source.ellipsoidCalculator);
        this.orientation = source.orientation;
        this.shellExternal = source.shellExternal;
        this.shellInternal = source.shellInternal;
        this.shellExternalOut = source.shellExternalOut;
        this.shellExternalSquared = source.shellExternalSquared;
        this.shellInternalSquared = source.shellInternalSquared;
        this.shellExternalOutSquared = source.shellExternalOutSquared;
        this.radiiShellMaxSquared = source.radiiShellMaxSquared;
    }

    @Override
    public String getName() {
        return "ellipsoid";
    }

    @Override
    public final byte isPointInside(Point3i point) {
        double y;
        if (point.distanceSquared(this.getPosition()) > this.radiiShellMaxSquared) {
            return FLAG_SUBMARK_NONE;
        }
        double x = (double)point.x() - this.getPosition().x() + 0.5;
        double sum = Ellipse.getEllipseSum(x, y = (double)point.y() - this.getPosition().y() + 0.5, this.ellipsoidCalculator.getEllipsoidMatrix());
        if (sum <= this.shellInternalSquared) {
            return FLAG_SUBMARK_REGION0;
        }
        if (sum <= 1.0) {
            return FLAG_SUBMARK_REGION1;
        }
        if (sum <= this.shellExternalSquared) {
            return FLAG_SUBMARK_REGION2;
        }
        if (sum <= this.shellExternalOutSquared) {
            return FLAG_SUBMARK_REGION3;
        }
        return FLAG_SUBMARK_NONE;
    }

    @Override
    public double volume(int regionID) {
        if (regionID == 0) {
            return this.areaForShell(1.0);
        }
        if (regionID == 1) {
            return this.areaForShell(this.shellExternal) - this.areaForShell(this.shellInternal);
        }
        assert (false);
        return 0.0;
    }

    public double circumference(int regionID) {
        if (regionID == 1) {
            return Ellipse.circumferenceUsingRamunjanApprox(this.radii.x() * (1.0 + this.shell), this.radii.y() * (1.0 + this.shell));
        }
        return Ellipse.circumferenceUsingRamunjanApprox(this.radii.x(), this.radii.y());
    }

    @Override
    public Ellipse duplicate() {
        return new Ellipse(this);
    }

    public String toString() {
        return String.format("%s %s pos=%s %s vol=%e shell=%f", "Ellpsd", this.identifier(), this.positionString(), this.descriptionMarks(), this.volume(0), this.shell);
    }

    public void updateshell(double shell) {
        this.setShell(shell);
        this.updateAfterMarkChange();
    }

    public void setMarksExplicit(Point3d position, Orientation orientation, Point2d radii) {
        Preconditions.checkArgument((position.z() == 0.0 ? 1 : 0) != 0, (Object)"non-zero z-value");
        super.setPosition(position);
        this.orientation = orientation;
        this.radii = radii;
        this.updateAfterMarkChange();
    }

    @Override
    public void setMarksExplicit(Point3d position) {
        this.setMarksExplicit(position, this.orientation, this.radii);
    }

    @Override
    public void setMarksExplicit(Point3d position, Orientation orientation) {
        this.setMarksExplicit(position, orientation, this.radii);
    }

    @Override
    public void setMarksExplicit(Point3d position, Orientation orientation, Point3d radii) {
        this.setMarksExplicit(position, orientation, new Point2d(radii.x(), radii.y()));
    }

    @Override
    public BoundingBox box(Dimensions dimensions, int regionID) {
        DoubleMatrix1D boxMatrix = this.ellipsoidCalculator.getBoundingBoxMatrix().copy();
        if (regionID == 1) {
            boxMatrix.assign(Functions.mult((double)this.shellExternalOut));
        }
        return BoundingBoxCalculator.boxFromBounds(this.getPosition(), boxMatrix, false, dimensions);
    }

    @Override
    public Optional<QuickOverlapCalculation> quickOverlap() {
        return Optional.of(this.quickOverlap);
    }

    public void setMarks(Point2d radii, Orientation orientation) {
        this.orientation = orientation;
        this.radii = radii;
        this.updateAfterMarkChange();
    }

    public void scaleRadii(double multFactor) {
        this.radii.scale(multFactor);
        this.updateAfterMarkChange();
    }

    @Override
    public void scale(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        super.scale(scaleFactor);
        ScaleChecker.checkIdenticalXY(scaleFactor);
        this.radii.scale(scaleFactor.x());
        this.updateAfterMarkChange();
    }

    @Override
    public boolean equalsDeep(Mark mark) {
        if (!super.equalsDeep(mark)) {
            return false;
        }
        if (!(mark instanceof Ellipse)) {
            return false;
        }
        Ellipse target = (Ellipse)mark;
        if (!this.radii.equals((Object)target.radii)) {
            return false;
        }
        return this.orientation.equals((Object)target.orientation);
    }

    @Override
    public int numberDimensions() {
        return 2;
    }

    @Override
    public double[] createRadiiArray() {
        return TensorUtilities.twoElementArray(this.radii.x(), this.radii.y());
    }

    @Override
    public double[] createRadiiArrayResolved(Optional<Resolution> resolution) {
        return TensorUtilities.twoElementArray(this.radii.x(), this.radii.y());
    }

    @Override
    public int numberRegions() {
        return 2;
    }

    @Override
    public BoundingBox boxAllRegions(Dimensions dimensions) {
        return this.box(dimensions, 1);
    }

    private String descriptionMarks() {
        return String.format("rad=[%3.3f, %3.3f] rot=%s", this.radii.x(), this.radii.y(), this.orientation);
    }

    private double areaForShell(double multiplier) {
        return Math.PI * this.radii.x() * this.radii.y() * Math.pow(multiplier, 2.0);
    }

    private double getMaximumRadius() {
        return this.ellipsoidCalculator.getMaximumRadius();
    }

    private void updateAfterMarkChange() {
        assert (this.shell > 0.0);
        DoubleMatrix2D matRot = this.orientation.getRotationMatrix().getMatrix();
        double[] radiusArray = TensorUtilities.twoElementArray(this.radii.x(), this.radii.y());
        this.ellipsoidCalculator.update(radiusArray, matRot);
        this.shellInternal = 1.0 - this.shell;
        this.shellExternal = 1.0 + this.shell;
        this.shellExternalOut = 1.0 + this.shell * 2.0;
        this.shellInternalSquared = TensorUtilities.squared(this.shellInternal);
        this.shellExternalSquared = TensorUtilities.squared(this.shellExternal);
        this.shellExternalOutSquared = TensorUtilities.squared(this.shellExternalOut);
        this.radiiShellMaxSquared = TensorUtilities.squared(this.ellipsoidCalculator.getMaximumRadius() * this.shellExternal);
        assert (!Double.isNaN(this.ellipsoidCalculator.getEllipsoidMatrix().get(0, 0)));
    }

    private static double circumferenceUsingRamunjanApprox(double a, double b) {
        double first = 3.0 * (a + b);
        double second = (3.0 * a + b) * (a + 3.0 * b);
        return Math.PI * (first - Math.sqrt(second));
    }

    private static double getEllipseSum(double x, double y, DoubleMatrix2D matrix) {
        return x * (x * matrix.get(0, 0) + y * matrix.get(1, 0)) + y * (x * matrix.get(0, 1) + y * matrix.get(1, 1));
    }

    public double getShell() {
        return this.shell;
    }

    public void setShell(double shell) {
        this.shell = shell;
    }

    public Point2d getRadii() {
        return this.radii;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }
}

