/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.conic;

import java.util.Optional;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.mpp.mark.conic.Ellipsoid;
import org.anchoranalysis.spatial.orientation.RotationMatrix;
import org.anchoranalysis.spatial.point.Point3d;

public class EllipsoidUtilities {
    public static double[] normalisedRadii(Ellipsoid mark, Optional<Resolution> resolution) {
        RotationMatrix rotMatrix = mark.getOrientation().getRotationMatrix();
        Point3d xRot = new Point3d(mark.getRadii().x(), 0.0, 0.0);
        Point3d yRot = new Point3d(0.0, mark.getRadii().y(), 0.0);
        Point3d zRot = new Point3d(0.0, 0.0, mark.getRadii().z());
        rotMatrix.rotatePointInplace(xRot);
        rotMatrix.rotatePointInplace(yRot);
        rotMatrix.rotatePointInplace(zRot);
        EllipsoidUtilities.adjustForZ(xRot, yRot, zRot, resolution);
        Point3d zero = new Point3d(0.0, 0.0, 0.0);
        double xNorm = xRot.distance(zero);
        double yNorm = yRot.distance(zero);
        double zNorm = zRot.distance(zero);
        return new double[]{xNorm, yNorm, zNorm};
    }

    private static void adjustForZ(Point3d xRot, Point3d yRot, Point3d zRot, Optional<Resolution> resolution) {
        if (resolution.isPresent()) {
            double zRel = resolution.get().zRelative();
            xRot.setZ(xRot.z() * zRel);
            yRot.setZ(yRot.z() * zRel);
            zRot.setZ(zRot.z() * zRel);
        }
    }

    private EllipsoidUtilities() {
    }
}

