/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.conic;

import com.google.common.base.Preconditions;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.conic.Ellipse;
import org.anchoranalysis.mpp.mark.conic.Ellipsoid;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.Orientation2D;
import org.anchoranalysis.spatial.orientation.Orientation3DEulerAngles;
import org.anchoranalysis.spatial.point.Point2d;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class MarkConicFactory {
    public static Mark createMarkFromPoint(Point3i point, int size, boolean do3D) {
        return MarkConicFactory.createMarkFromPoint(PointConverter.doubleFromInt((ReadableTuple3i)point), size, do3D);
    }

    public static Mark createMarkFromPoint(Point3d point, int size, boolean do3D) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Size must be positive");
        Preconditions.checkArgument((do3D || point.z() == 0.0 ? 1 : 0) != 0, (Object)"Z-coordinate must be 0 for 2D marks");
        if (do3D) {
            Ellipsoid me = new Ellipsoid();
            me.setMarksExplicit(point, (Orientation)new Orientation3DEulerAngles(0.0, 0.0, 0.0), new Point3d((double)size, (double)size, (double)size));
            return me;
        }
        Ellipse me = new Ellipse();
        me.setMarksExplicit(point, (Orientation)new Orientation2D(), new Point2d((double)size, (double)size));
        return me;
    }

    private MarkConicFactory() {
    }
}

