/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.conic;

import java.io.Serializable;
import java.util.Optional;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.bound.Bound;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipUtilities;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkWithPosition;
import org.anchoranalysis.mpp.mark.QuickOverlapCalculation;
import org.anchoranalysis.mpp.mark.conic.BoundingBoxCalculator;
import org.anchoranalysis.mpp.mark.conic.ScaleChecker;
import org.anchoranalysis.mpp.mark.conic.TensorUtilities;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public abstract class MarkWithPositionAndSingleRadius
extends MarkWithPosition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte FLAG_SUBMARK_NONE = RegionMembershipUtilities.flagForNoRegion();
    private static final byte FLAG_SUBMARK_INSIDE = RegionMembershipUtilities.flagForRegion(0);
    private static final byte FLAG_SUBMARK_SHELL = RegionMembershipUtilities.flagForRegion(1);
    private static final double ADDED_TO_RADIUS = 0.5;
    private static final double SPHERE_EXTRA_RAD = 2.0;
    private double radius;
    private double radiusSq;
    private double radiusExtraSq;
    private Bound boundRadius;
    private transient QuickOverlapCalculation quickOverlap = (mark, regionID) -> {
        if (this.getClass().equals(mark.getClass())) {
            MarkWithPositionAndSingleRadius markCast = (MarkWithPositionAndSingleRadius)mark;
            double radiusSum = this.radius + markCast.radius;
            double distanceBetweenCenters = this.getPosition().distance(markCast.getPosition());
            return radiusSum > distanceBetweenCenters;
        }
        throw new UnsupportedOperationException();
    };

    protected MarkWithPositionAndSingleRadius(Bound boundRadius) {
        this.boundRadius = boundRadius;
    }

    protected MarkWithPositionAndSingleRadius(MarkWithPositionAndSingleRadius src) {
        super(src);
        this.boundRadius = src.boundRadius;
        this.radius = src.radius;
        this.radiusSq = src.radiusSq;
        this.radiusExtraSq = src.radiusExtraSq;
    }

    @Override
    public void scale(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        super.scale(scaleFactor);
        ScaleChecker.checkIdenticalXY(scaleFactor);
        if (this.boundRadius != null) {
            this.boundRadius = this.boundRadius.duplicate();
            this.boundRadius.scale(scaleFactor.x());
        }
        this.setRadius(this.radius * scaleFactor.x());
    }

    @Override
    public BoundingBox box(Dimensions dimensions, int regionID) {
        return BoundingBoxCalculator.boxFromBounds(this.getPosition(), this.radiusForRegion(regionID) + 0.5, this.numberDimensions() == 3, dimensions);
    }

    @Override
    public BoundingBox boxAllRegions(Dimensions dimensions) {
        return this.box(dimensions, 1);
    }

    @Override
    public final byte isPointInside(Point3i point) {
        double distance = this.getPosition().distanceSquared(point);
        if (distance <= this.radiusSq) {
            return FLAG_SUBMARK_INSIDE;
        }
        if (distance <= this.radiusExtraSq) {
            return FLAG_SUBMARK_SHELL;
        }
        return FLAG_SUBMARK_NONE;
    }

    @Override
    public Optional<QuickOverlapCalculation> quickOverlap() {
        return Optional.of(this.quickOverlap);
    }

    @Override
    public int numberRegions() {
        return 2;
    }

    @Override
    public boolean equalsDeep(Mark mark) {
        if (!super.equalsDeep(mark)) {
            return false;
        }
        if (!mark.getClass().equals(this.getClass())) {
            return false;
        }
        MarkWithPositionAndSingleRadius trgt = (MarkWithPositionAndSingleRadius)mark;
        return this.radius == trgt.radius;
    }

    public String strMarks() {
        return String.format("rad=%8.3f", this.radius);
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.radiusSq = TensorUtilities.squared(radius);
        this.radiusExtraSq = TensorUtilities.squared(radius + 2.0);
    }

    protected double radiusForRegion(int regionID) {
        return regionID == 0 ? this.radius : this.radius + 2.0;
    }

    protected double radiusForRegionSquared(int regionID) {
        return regionID == 0 ? this.radiusSq : this.radiusExtraSq;
    }

    protected MarkWithPositionAndSingleRadius() {
    }

    public double getRadius() {
        return this.radius;
    }

    public Bound getBoundRadius() {
        return this.boundRadius;
    }
}

