/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.mpp.mark.conic;

import org.anchoranalysis.mpp.bean.bound.Bound;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.conic.MarkWithPositionAndSingleRadius;

public class Sphere
extends MarkWithPositionAndSingleRadius {
    private static final long serialVersionUID = -3526056946146656810L;

    public Sphere(Bound boundRadius) {
        super(boundRadius);
    }

    public Sphere(Sphere source) {
        super(source);
    }

    @Override
    public String getName() {
        return "sphere";
    }

    @Override
    public double volume(int regionID) {
        double radiusCubed = Math.pow(this.radiusForRegion(regionID), 3.0);
        return Math.PI * 4 * radiusCubed / 3.0;
    }

    public String toString() {
        return String.format("%s %s pos=%s %s", "Sphr", this.identifier(), this.positionString(), this.strMarks());
    }

    @Override
    public Mark duplicate() {
        return new Sphere(this);
    }

    @Override
    public int numberDimensions() {
        return 3;
    }

    public Sphere() {
    }
}

